/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.debug.views;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.elk.alg.disco.debug.views.ConfigState;
import org.eclipse.elk.alg.disco.debug.views.DisCoGraphRenderingCanvas;
import org.eclipse.elk.alg.disco.debug.views.State;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class DropdownIntRangeAction
extends Action
implements IMenuCreator,
Observer {
    private Menu menu;
    private int lb;
    private int ub;
    private String label;
    private DropdownIntRangeAction that;
    private State bound;
    private ConfigState state;
    private DisCoGraphRenderingCanvas canvas;

    public DropdownIntRangeAction(ConfigState observeable, String label, int low, int high, int initial, State bound, DisCoGraphRenderingCanvas canvas) {
        super(String.valueOf(label) + initial, 4);
        this.lb = low;
        this.ub = high;
        this.that = this;
        this.label = label;
        this.bound = bound;
        this.setMenuCreator(this);
        observeable.addObserver(this);
        this.state = observeable;
        this.canvas = canvas;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        int i = this.lb;
        while (i <= this.ub) {
            NumAction numAction = new NumAction("" + i);
            numAction.setCanvas(this.canvas);
            this.addToMenu(this.menu, numAction);
            ++i;
        }
        return this.menu;
    }

    void updateLabel(String add) {
        this.setText(String.valueOf(this.label) + add);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void addToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (State.LOWER.equals(arg) && this.bound.equals((Object)State.LOWER)) {
            this.updateLabel("" + this.state.getLowerLvl());
        } else if (State.UPPER.equals(arg) && this.bound.equals((Object)State.UPPER)) {
            this.updateLabel("" + this.state.getUpperLvl());
        } else if (State.DEPTH.equals(arg)) {
            this.ub = this.state.getMaxDepth() - 1;
        }
    }

    private class NumAction
    extends Action {
        private DisCoGraphRenderingCanvas canvas;

        NumAction(String text) {
            super(text);
        }

        public void run() {
            String number = this.getText();
            int num = Integer.parseInt(number);
            DropdownIntRangeAction.this.that.updateLabel(number);
            if (DropdownIntRangeAction.this.that.bound.equals((Object)State.LOWER)) {
                DropdownIntRangeAction.this.that.state.setLow(num);
            } else {
                DropdownIntRangeAction.this.that.state.setHigh(num);
            }
            this.canvas.redraw();
        }

        public void setCanvas(DisCoGraphRenderingCanvas canvas) {
            this.canvas = canvas;
        }
    }
}

