/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore;

import org.eclipse.elk.alg.spore.ElkGraphImporter;
import org.eclipse.elk.alg.spore.ShrinkTree;
import org.eclipse.elk.alg.spore.graph.Graph;
import org.eclipse.elk.alg.spore.options.SporeCompactionOptions;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class ShrinkTreeLayoutProvider
extends AbstractLayoutProvider {
    private ShrinkTree shrinktree = new ShrinkTree();

    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        if (layoutGraph.hasProperty(SporeCompactionOptions.UNDERLYING_LAYOUT_ALGORITHM)) {
            String requestedAlgorithm = (String)layoutGraph.getProperty(SporeCompactionOptions.UNDERLYING_LAYOUT_ALGORITHM);
            LayoutAlgorithmData lad = LayoutMetaDataService.getInstance().getAlgorithmDataBySuffix(requestedAlgorithm);
            if (lad != null) {
                AbstractLayoutProvider layoutProvider = (AbstractLayoutProvider)lad.getInstancePool().fetch();
                layoutProvider.layout(layoutGraph, progressMonitor.subTask(1.0f));
            }
        }
        ElkGraphImporter graphImporter = new ElkGraphImporter();
        Graph graph = graphImporter.importGraph(layoutGraph);
        this.shrinktree.shrink(graph, progressMonitor.subTask(1.0f));
        graphImporter.applyPositions(graph);
    }
}

