/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial;

import com.google.common.collect.Iterables;
import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public final class RadialUtil {
    private static final double TWO_PI = Math.PI * 2;
    private static final double EPSILON = 1.0E-10;

    private RadialUtil() {
    }

    public static List<ElkNode> getSuccessors(ElkNode node) {
        ArrayList<ElkNode> successors = new ArrayList<ElkNode>();
        HashSet children = new HashSet(node.getChildren());
        for (ElkEdge outgoingEdge : ElkGraphUtil.allOutgoingEdges((ElkNode)node)) {
            ElkNode target;
            if (outgoingEdge.getSources().get(0) instanceof ElkPort || children.contains(target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)outgoingEdge.getTargets().get(0))))) continue;
            successors.add(target);
        }
        return successors;
    }

    public static Set<ElkNode> getSuccessorSet(ElkNode node) {
        HashSet<ElkNode> successors = new HashSet<ElkNode>();
        HashSet children = new HashSet(node.getChildren());
        for (ElkEdge outgoingEdge : ElkGraphUtil.allOutgoingEdges((ElkNode)node)) {
            ElkNode target;
            if (outgoingEdge.getSources().get(0) instanceof ElkPort || children.contains(target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)outgoingEdge.getTargets().get(0))))) continue;
            successors.add(target);
        }
        return successors;
    }

    public static ElkNode findRoot(ElkNode graph) {
        for (ElkNode child : graph.getChildren()) {
            Iterable incomingEdges = ElkGraphUtil.allIncomingEdges((ElkNode)child);
            if (incomingEdges.iterator().hasNext()) continue;
            return child;
        }
        return null;
    }

    public static ElkNode findRootOfNode(ElkNode elkNode) {
        ElkNode parent = RadialUtil.getTreeParent(elkNode);
        if (parent == null) {
            return elkNode;
        }
        return RadialUtil.findRootOfNode(parent);
    }

    public static int getNumberOfLeaves(ElkNode node) {
        int leafs = 0;
        List<ElkNode> successors = RadialUtil.getSuccessors(node);
        if (successors.isEmpty()) {
            return 1;
        }
        for (ElkNode child : successors) {
            leafs += RadialUtil.getNumberOfLeaves(child);
        }
        return leafs;
    }

    public static Comparator<ElkNode> createPolarComparator(double radialOffset, double nodeOffsetY) {
        Comparator comparator = (node1, node2) -> {
            KVector position1 = (KVector)node1.getProperty(CoreOptions.POSITION);
            double yPos1 = position1.y + nodeOffsetY;
            double xPos1 = position1.x;
            double arc1 = Math.atan2(yPos1, xPos1);
            if (arc1 < 0.0) {
                arc1 += Math.PI * 2;
            }
            if ((arc1 += radialOffset) > Math.PI * 2) {
                arc1 -= Math.PI * 2;
            }
            KVector position2 = (KVector)node2.getProperty(CoreOptions.POSITION);
            double yPos2 = position2.y + nodeOffsetY;
            double xPos2 = position2.x;
            double arc2 = Math.atan2(yPos2, xPos2);
            if (arc2 < 0.0) {
                arc2 += Math.PI * 2;
            }
            if ((arc2 += radialOffset) > Math.PI * 2) {
                arc2 -= Math.PI * 2;
            }
            return DoubleMath.fuzzyCompare((double)arc1, (double)arc2, (double)1.0E-10);
        };
        return comparator;
    }

    public static double findLargestNodeInGraph(ElkNode graph) {
        double largestChildSize = 0.0;
        for (ElkNode child : graph.getChildren()) {
            double width = child.getWidth();
            double height = child.getHeight();
            double diameter = Math.sqrt(width * width + height * height);
            largestChildSize = Math.max(diameter, largestChildSize);
            double largestChild = RadialUtil.findLargestNodeInGraph(child);
            largestChildSize = Math.max(largestChild, largestChildSize);
        }
        return largestChildSize;
    }

    public static List<ElkNode> getNextLevelNodes(List<ElkNode> nodes) {
        ArrayList<ElkNode> successors = new ArrayList<ElkNode>();
        for (ElkNode node : nodes) {
            List<ElkNode> nextLevelNodes = RadialUtil.getSuccessors(node);
            successors.addAll(nextLevelNodes);
        }
        return successors;
    }

    public static Set<ElkNode> getNextLevelNodeSet(List<ElkNode> nodes) {
        HashSet<ElkNode> successors = new HashSet<ElkNode>();
        for (ElkNode node : nodes) {
            Set<ElkNode> nextLevelSet = RadialUtil.getSuccessorSet(node);
            successors.addAll(nextLevelSet);
        }
        return successors;
    }

    public static List<ElkNode> getLastLevelNodes(List<ElkNode> nodes) {
        ArrayList<ElkNode> parents = new ArrayList<ElkNode>();
        for (ElkNode node : nodes) {
            ElkNode parent = RadialUtil.getTreeParent(node);
            parents.add(parent);
        }
        return parents;
    }

    public static void centerNodesOnRadi(ElkNode node, double xPos, double yPos) {
        double xPosition = xPos - node.getWidth() / 2.0;
        double yPosition = yPos - node.getHeight() / 2.0;
        node.setX(xPosition);
        node.setY(yPosition);
    }

    public static void shiftClosestEdgeToRadi(ElkNode node, double xPos, double yPos) {
        if (DoubleMath.fuzzyEquals((double)xPos, (double)0.0, (double)1.0E-10) && DoubleMath.fuzzyEquals((double)yPos, (double)0.0, (double)1.0E-10)) {
            node.setX(xPos - node.getWidth() / 2.0);
            node.setY(yPos - node.getHeight() / 2.0);
        } else if (xPos < 0.0) {
            if (yPos < 0.0) {
                node.setX(xPos - node.getWidth());
                node.setY(yPos);
            } else {
                node.setX(xPos - node.getWidth());
                node.setY(yPos + node.getHeight());
            }
        } else if (yPos < 0.0) {
            node.setX(xPos);
            node.setY(yPos);
        } else {
            node.setX(xPos);
            node.setY(yPos + node.getHeight());
        }
    }

    public static ElkNode getTreeParent(ElkNode node) {
        Iterable iterator = ElkGraphUtil.allIncomingEdges((ElkNode)node);
        if (!Iterables.isEmpty((Iterable)iterator)) {
            ElkEdge edgeFromParent = (ElkEdge)Iterables.get((Iterable)iterator, (int)0);
            return ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edgeFromParent.getSources().get(0)));
        }
        return null;
    }
}

