/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.acceleo.query.ast.And;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.ast.ErrorBinding;
import org.eclipse.acceleo.query.ast.ErrorCall;
import org.eclipse.acceleo.query.ast.ErrorEClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorEnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorStringLiteral;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorVariableDeclaration;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Implies;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.Literal;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.Or;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.parser.QueryBaseListener;
import org.eclipse.acceleo.query.parser.QueryParser;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EEnumLiteral;

public class AstBuilderListener
extends QueryBaseListener {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.query";
    public static final String FEATURE_ACCESS_SERVICE_NAME = "aqlFeatureAccess";
    public static final String OCL_IS_KIND_OF_SERVICE_NAME = "oclIsKindOf";
    public static final String OCL_IS_TYPE_OF_SERVICE_NAME = "oclIsTypeOf";
    public static final String CONDITIONAL_OPERATOR = "if";
    public static final String NOT_SERVICE_NAME = "not";
    public static final String NOT_OPERATOR = "not";
    public static final String LET_OPERATOR = "let";
    public static final String DIFFERS_SERVICE_NAME = "differs";
    public static final String DIFFERS_OPERATOR = "<>";
    public static final String DIFFERS_JAVA_OPERATOR = "!=";
    public static final String EQUALS_SERVICE_NAME = "equals";
    public static final String EQUALS_OPERATOR = "=";
    public static final String EQUALS_JAVA_OPERATOR = "==";
    public static final String GREATER_THAN_EQUAL_SERVICE_NAME = "greaterThanEqual";
    public static final String GREATER_THAN_EQUAL_OPERATOR = ">=";
    public static final String GREATER_THAN_SERVICE_NAME = "greaterThan";
    public static final String GREATER_THAN_OPERATOR = ">";
    public static final String LESS_THAN_EQUAL_SERVICE_NAME = "lessThanEqual";
    public static final String LESS_THAN_EQUAL_OPERATOR = "<=";
    public static final String LESS_THAN_SERVICE_NAME = "lessThan";
    public static final String LESS_THAN_OPERATOR = "<";
    public static final String DIV_SERVICE_NAME = "divOp";
    public static final String DIV_OPERATOR = "/";
    public static final String MULT_SERVICE_NAME = "mult";
    public static final String MULT_OPERATOR = "*";
    public static final String SUB_SERVICE_NAME = "sub";
    public static final String SUB_OPERATOR = "-";
    public static final String ADD_SERVICE_NAME = "add";
    public static final String ADD_OPERATOR = "+";
    public static final String UNARY_MIN_SERVICE_NAME = "unaryMin";
    public static final String UNARY_MIN_OPERATOR = "-";
    public static final String AND_SERVICE_NAME = "and";
    public static final String AND_OPERATOR = "and";
    public static final String OR_SERVICE_NAME = "or";
    public static final String OR_OPERATOR = "or";
    public static final String XOR_SERVICE_NAME = "xor";
    public static final String XOR_OPERATOR = "xor";
    public static final String IMPLIES_SERVICE_NAME = "implies";
    public static final String IMPLIES_OPERATOR = "implies";
    public static final Set<String> OPERATOR_SERVICE_NAMES = AstBuilderListener.initOperatorServiceNames();
    private static final String THIS_SHOULDN_T_HAPPEN = "This shouldn't happen.";
    private static final String INVALID_ENUM_LITERAL = "invalid enum literal: %s";
    private static final String INVALID_TYPE_LITERAL = "invalid type literal %s";
    private static final String AMBIGUOUS_ENUM_LITERAL = "several enumliterals are matching the literal name: %s, eenum : %s and package name : %s";
    private static final String AMBIGUOUS_TYPE_LITERAL = "several types are matching the EClassifier name: %s , package name : %s";
    private static final int CONDITIONAL_CONTEXT_CHILD_COUNT = 7;
    private static final int NO_ERROR = -1;
    private static final String INTERNAL_ERROR_MSG = "Internal exception occured while evaluating an expression";
    private Stack<Object> stack = new Stack();
    private int errorRule = -1;
    private final Map<Object, Integer> startPositions = new HashMap<Object, Integer>();
    private final Map<Object, Integer> endPositions = new HashMap<Object, Integer>();
    private final List<Error> errors = new ArrayList<Error>();
    private Stack<Diagnostic> diagnosticStack = new Stack();
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
    private final ANTLRErrorListener errorListener = new QueryErrorListener();
    private final AstBuilder builder = new AstBuilder();
    private final IReadOnlyQueryEnvironment environment;

    public AstBuilderListener(IReadOnlyQueryEnvironment environment) {
        this.environment = environment;
    }

    private static Set<String> initOperatorServiceNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(ADD_SERVICE_NAME);
        result.add("and");
        result.add(DIFFERS_SERVICE_NAME);
        result.add(DIV_SERVICE_NAME);
        result.add(EQUALS_SERVICE_NAME);
        result.add(GREATER_THAN_EQUAL_SERVICE_NAME);
        result.add(GREATER_THAN_SERVICE_NAME);
        result.add("implies");
        result.add(LESS_THAN_EQUAL_SERVICE_NAME);
        result.add(LESS_THAN_SERVICE_NAME);
        result.add(MULT_SERVICE_NAME);
        result.add("not");
        result.add("or");
        result.add(SUB_SERVICE_NAME);
        result.add(UNARY_MIN_SERVICE_NAME);
        result.add("xor");
        return result;
    }

    public IQueryBuilderEngine.AstResult getAstResult() {
        Expression ast = this.popExpression();
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        for (Diagnostic diag : this.diagnostics) {
            diagnostic.add(diag);
        }
        return new IQueryBuilderEngine.AstResult(ast, this.startPositions, this.endPositions, this.errors, (Diagnostic)diagnostic);
    }

    private Expression popExpression() {
        try {
            List data;
            Expression expression = (Expression)this.pop();
            if (!this.diagnosticStack.isEmpty() && (data = this.diagnosticStack.peek().getData()).get(0).equals(this.startPositions.get(expression)) && data.get(1).equals(this.endPositions.get(expression))) {
                Diagnostic tmpDiagnostic = this.diagnosticStack.pop();
                this.diagnostics.add((Diagnostic)new BasicDiagnostic(tmpDiagnostic.getSeverity(), tmpDiagnostic.getSource(), tmpDiagnostic.getCode(), tmpDiagnostic.getMessage(), new Object[]{expression}));
            }
            return expression;
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException cce) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, cce);
        }
    }

    private Binding popBinding() {
        try {
            return (Binding)this.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private VariableDeclaration popVariableDeclaration() {
        try {
            return (VariableDeclaration)this.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private TypeLiteral popTypeLiteral() {
        try {
            return (TypeLiteral)this.pop();
        }
        catch (EmptyStackException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        catch (ClassCastException e2) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e2);
        }
    }

    private Call peekCall() {
        return (Call)this.stack.peek();
    }

    private void push(Object obj) {
        this.stack.push(obj);
    }

    protected Object pop() {
        Object element = this.stack.pop();
        return element;
    }

    private void pushError(Error error, String msg) {
        this.errors.add(error);
        this.diagnostics.add((Diagnostic)new BasicDiagnostic(4, PLUGIN_ID, 0, msg, new Object[]{error}));
        this.push(error);
    }

    private void popErrorExpression() {
        if (!this.stack.isEmpty() && this.stack.peek() instanceof ErrorExpression) {
            ErrorExpression error = (ErrorExpression)this.pop();
            this.errors.remove(error);
            this.startPositions.remove(error);
            this.endPositions.remove(error);
            this.diagnostics.remove(this.diagnostics.size() - 1);
        }
    }

    @Override
    public void exitIntType(QueryParser.IntTypeContext ctx) {
        Literal typeLiteral = this.builder.typeLiteral(Integer.class);
        this.startPositions.put(typeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(typeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(typeLiteral);
    }

    @Override
    public void exitFalseLit(QueryParser.FalseLitContext ctx) {
        BooleanLiteral booleanLiteral = this.builder.booleanLiteral(false);
        this.startPositions.put(booleanLiteral, ctx.start.getStartIndex());
        this.endPositions.put(booleanLiteral, ctx.stop.getStopIndex() + 1);
        this.push(booleanLiteral);
    }

    @Override
    public void exitRealType(QueryParser.RealTypeContext ctx) {
        Literal realLiteral = this.builder.typeLiteral(Double.class);
        this.startPositions.put(realLiteral, ctx.start.getStartIndex());
        this.endPositions.put(realLiteral, ctx.stop.getStopIndex() + 1);
        this.push(realLiteral);
    }

    @Override
    public void exitTrueLit(QueryParser.TrueLitContext ctx) {
        BooleanLiteral booleanLiteral = this.builder.booleanLiteral(true);
        this.startPositions.put(booleanLiteral, ctx.start.getStartIndex());
        this.endPositions.put(booleanLiteral, ctx.stop.getStopIndex() + 1);
        this.push(booleanLiteral);
    }

    @Override
    public void exitSeqType(QueryParser.SeqTypeContext ctx) {
        TypeLiteral elementType = this.popTypeLiteral();
        CollectionTypeLiteral collectionTypeLiteral = this.builder.collectionTypeLiteral(List.class, elementType);
        this.startPositions.put(collectionTypeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(collectionTypeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(collectionTypeLiteral);
    }

    @Override
    public void exitSetType(QueryParser.SetTypeContext ctx) {
        TypeLiteral elementType = this.popTypeLiteral();
        CollectionTypeLiteral collectionTypeLiteral = this.builder.collectionTypeLiteral(Set.class, elementType);
        this.startPositions.put(collectionTypeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(collectionTypeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(collectionTypeLiteral);
    }

    @Override
    public void exitNot(QueryParser.NotContext ctx) {
        Call callService = this.builder.callService("not", this.popExpression());
        this.startPositions.put(callService, ctx.start.getStartIndex());
        this.endPositions.put(callService, ctx.stop.getStopIndex() + 1);
        this.push(callService);
    }

    @Override
    public void exitStringLit(QueryParser.StringLitContext ctx) {
        String text = ctx.getText();
        StringLiteral stringLiteral = this.builder.stringLiteral(text.substring(1, text.length() - 1));
        this.startPositions.put(stringLiteral, ctx.start.getStartIndex());
        this.endPositions.put(stringLiteral, ctx.stop.getStopIndex() + 1);
        this.push(stringLiteral);
    }

    @Override
    public void exitErrorStringLit(QueryParser.ErrorStringLitContext ctx) {
        String text = ctx.getText();
        ErrorStringLiteral errorStringLiteral = this.builder.errorStringLiteral(text.substring(1, text.length()));
        this.startPositions.put(errorStringLiteral, ctx.start.getStartIndex());
        this.endPositions.put(errorStringLiteral, ctx.stop.getStopIndex() + 1);
        this.pushError(errorStringLiteral, "String literal is not properly closed by a simple-quote: " + text);
    }

    @Override
    public void exitRealLit(QueryParser.RealLitContext ctx) {
        RealLiteral realLiteral = this.builder.realLiteral(Double.valueOf(ctx.getText()));
        this.startPositions.put(realLiteral, ctx.start.getStartIndex());
        this.endPositions.put(realLiteral, ctx.stop.getStopIndex() + 1);
        this.push(realLiteral);
    }

    @Override
    public void exitStrType(QueryParser.StrTypeContext ctx) {
        Literal typeLiteral = this.builder.typeLiteral(String.class);
        this.startPositions.put(typeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(typeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(typeLiteral);
    }

    @Override
    public void exitOr(QueryParser.OrContext ctx) {
        Expression op2 = this.popExpression();
        Expression op1 = this.popExpression();
        Or callService = this.builder.callOrService(op1, op2);
        this.startPositions.put(callService, this.startPositions.get(op1));
        this.endPositions.put(callService, this.endPositions.get(op2));
        this.push(callService);
    }

    @Override
    public void exitXor(QueryParser.XorContext ctx) {
        this.pushBinary("xor", ctx);
    }

    @Override
    public void exitImplies(QueryParser.ImpliesContext ctx) {
        Expression op2 = this.popExpression();
        Expression op1 = this.popExpression();
        Implies callService = this.builder.callImpliesService(op1, op2);
        this.startPositions.put(callService, this.startPositions.get(op1));
        this.endPositions.put(callService, this.endPositions.get(op2));
        this.push(callService);
    }

    @Override
    public void exitBooleanType(QueryParser.BooleanTypeContext ctx) {
        Literal typeLiteral = this.builder.typeLiteral(Boolean.class);
        this.startPositions.put(typeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(typeLiteral, ctx.stop.getStopIndex() + 1);
        this.push(typeLiteral);
    }

    @Override
    public void exitIntegerLit(QueryParser.IntegerLitContext ctx) {
        IntegerLiteral integerLiteral = this.builder.integerLiteral(Integer.valueOf(ctx.getText()));
        this.startPositions.put(integerLiteral, ctx.start.getStartIndex());
        this.endPositions.put(integerLiteral, ctx.stop.getStopIndex() + 1);
        this.push(integerLiteral);
    }

    @Override
    public void exitAnd(QueryParser.AndContext ctx) {
        Expression op2 = this.popExpression();
        Expression op1 = this.popExpression();
        And callService = this.builder.callAndService(op1, op2);
        this.startPositions.put(callService, this.startPositions.get(op1));
        this.endPositions.put(callService, this.endPositions.get(op2));
        this.push(callService);
    }

    @Override
    public void exitVarRef(QueryParser.VarRefContext ctx) {
        VarRef varRef = this.builder.varRef(ctx.getText());
        this.startPositions.put(varRef, ctx.start.getStartIndex());
        this.endPositions.put(varRef, ctx.stop.getStopIndex() + 1);
        this.push(varRef);
    }

    @Override
    public void exitFeature(QueryParser.FeatureContext ctx) {
        Expression receiver = this.popExpression();
        StringLiteral featureName = this.builder.stringLiteral(ctx.getChild(1).getText());
        Call call = this.builder.callService(FEATURE_ACCESS_SERVICE_NAME, receiver, featureName);
        call.setType(CallType.CALLORAPPLY);
        this.startPositions.put(featureName, ctx.stop.getStartIndex());
        this.endPositions.put(featureName, ctx.stop.getStopIndex() + 1);
        this.startPositions.put(call, this.startPositions.get(receiver));
        this.endPositions.put(call, ctx.stop.getStopIndex() + 1);
        this.push(call);
    }

    private void pushBinary(String service, ParserRuleContext ctx) {
        Expression op2 = this.popExpression();
        Expression op1 = this.popExpression();
        Call callService = this.builder.callService(service, op1, op2);
        this.startPositions.put(callService, this.startPositions.get(op1));
        this.endPositions.put(callService, this.endPositions.get(op2));
        this.push(callService);
    }

    @Override
    public void exitServiceCall(QueryParser.ServiceCallContext ctx) {
        if (this.errorRule != 5) {
            Call call;
            int argc = this.getNumberOfArgs(ctx.getChild(2).getChildCount());
            Expression[] args = new Expression[argc];
            int i = argc - 1;
            while (i >= 0) {
                args[i] = this.popExpression();
                --i;
            }
            String serviceName = ctx.getChild(0).getText().replace("::", ".");
            if (ctx.getChild(ctx.getChildCount() - 1) instanceof ErrorNode) {
                call = this.builder.errorCall(serviceName, true, args);
                this.pushError((Error)((Object)call), "missing ')'");
            } else {
                call = this.builder.callService(serviceName, args);
                this.push(call);
            }
            this.startPositions.put(call, this.startPositions.get(args[0]));
            this.endPositions.put(call, ctx.stop.getStopIndex() + 1);
        }
    }

    private int getNumberOfArgs(int childCount) {
        int result = childCount == 0 ? 1 : 2 + childCount / 2;
        return result;
    }

    @Override
    public void exitMin(QueryParser.MinContext ctx) {
        Call callService = this.builder.callService(UNARY_MIN_SERVICE_NAME, this.popExpression());
        this.startPositions.put(callService, ctx.start.getStartIndex());
        this.endPositions.put(callService, ctx.stop.getStopIndex() + 1);
        this.push(callService);
    }

    @Override
    public void exitAdd(QueryParser.AddContext ctx) {
        String op = ctx.getChild(1).getText();
        if (ADD_OPERATOR.equals(op)) {
            this.pushBinary(ADD_SERVICE_NAME, ctx);
        } else if ("-".equals(op)) {
            this.pushBinary(SUB_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitMult(QueryParser.MultContext ctx) {
        String op = ctx.getChild(1).getText();
        if (MULT_OPERATOR.equals(op)) {
            this.pushBinary(MULT_SERVICE_NAME, ctx);
        } else if (DIV_OPERATOR.equals(op)) {
            this.pushBinary(DIV_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitComp(QueryParser.CompContext ctx) {
        String op = ctx.getChild(1).getText();
        if (LESS_THAN_OPERATOR.equals(op)) {
            this.pushBinary(LESS_THAN_SERVICE_NAME, ctx);
        } else if (LESS_THAN_EQUAL_OPERATOR.equals(op)) {
            this.pushBinary(LESS_THAN_EQUAL_SERVICE_NAME, ctx);
        } else if (GREATER_THAN_OPERATOR.equals(op)) {
            this.pushBinary(GREATER_THAN_SERVICE_NAME, ctx);
        } else if (GREATER_THAN_EQUAL_OPERATOR.equals(op)) {
            this.pushBinary(GREATER_THAN_EQUAL_SERVICE_NAME, ctx);
        } else if (EQUALS_OPERATOR.equals(op) || EQUALS_JAVA_OPERATOR.equals(op)) {
            this.pushBinary(EQUALS_SERVICE_NAME, ctx);
        } else if (DIFFERS_OPERATOR.equals(op) || DIFFERS_JAVA_OPERATOR.equals(op)) {
            this.pushBinary(DIFFERS_SERVICE_NAME, ctx);
        } else {
            throw new AcceleoQueryEvaluationException(THIS_SHOULDN_T_HAPPEN);
        }
    }

    @Override
    public void exitCollectionCall(QueryParser.CollectionCallContext ctx) {
        this.peekCall().setType(CallType.COLLECTIONCALL);
    }

    @Override
    public void exitCallOrApply(QueryParser.CallOrApplyContext ctx) {
        this.peekCall().setType(CallType.CALLORAPPLY);
    }

    @Override
    public void exitVariableDefinition(QueryParser.VariableDefinitionContext ctx) {
        if (this.errorRule == -1) {
            VariableDeclaration variableDeclaration;
            if (ctx.getChildCount() == 4) {
                TypeLiteral typeLiteral = this.popTypeLiteral();
                Expression variableExpression = this.popExpression();
                variableDeclaration = this.builder.variableDeclaration(ctx.getChild(0).getText(), typeLiteral, variableExpression);
                this.endPositions.put(variableDeclaration, ((ParserRuleContext)ctx.getChild((int)2)).stop.getStopIndex() + 1);
            } else {
                Expression variableExpression = this.popExpression();
                variableDeclaration = this.builder.variableDeclaration(ctx.getChild(0).getText(), variableExpression);
                this.endPositions.put(variableDeclaration, ((TerminalNode)ctx.getChild(0)).getSymbol().getStopIndex() + 1);
            }
            this.startPositions.put(variableDeclaration, ctx.start.getStartIndex());
            this.push(variableDeclaration);
        } else {
            this.errorRule = -1;
        }
    }

    @Override
    public void exitIterationCall(QueryParser.IterationCallContext ctx) {
        Call call;
        String serviceName = ctx.getChild(0).getText();
        Expression ast = this.popExpression();
        this.popErrorExpression();
        VariableDeclaration iterator = this.popVariableDeclaration();
        Lambda lambda = this.builder.lambda(ast, iterator);
        this.startPositions.put(lambda, this.startPositions.get(ast));
        this.endPositions.put(lambda, (int)this.endPositions.get(ast));
        if (ctx.getChild(ctx.getChildCount() - 1) instanceof ErrorNode) {
            ParserRuleContext parenthesisNode = (ParserRuleContext)ctx.getChild(ctx.getChildCount() - 2).getChild(0);
            boolean missingParenthesis = parenthesisNode != null && !")".equals(parenthesisNode.stop.getText());
            call = this.builder.errorCall(serviceName, missingParenthesis, iterator.getExpression(), lambda);
            if (missingParenthesis) {
                this.pushError((Error)((Object)call), "missing ')'");
            } else {
                this.pushError((Error)((Object)call), "invalid iteration call");
            }
        } else {
            call = this.builder.callService(serviceName, iterator.getExpression(), lambda);
            this.push(call);
        }
        this.startPositions.put(call, this.startPositions.get(iterator.getExpression()));
        this.endPositions.put(call, ctx.stop.getStopIndex() + 1);
    }

    @Override
    public void exitEnumLit(QueryParser.EnumLitContext ctx) {
        if (ctx.getChildCount() >= 5) {
            EnumLiteral toPush;
            String ePackageName = ctx.getChild(0).getText();
            String eEnumName = ctx.getChild(2).getText();
            Integer startPosition = ctx.start.getStartIndex();
            Integer stopPosition = ctx.stop.getStopIndex() + 1;
            String eEnumLiteralName = ctx.getChild(4).getText();
            Collection<EEnumLiteral> eEnumLiterals = this.environment.getEPackageProvider().getEnumLiterals(ePackageName, eEnumName, eEnumLiteralName);
            if (eEnumLiterals.size() == 0) {
                ArrayList<String> segments = new ArrayList<String>(3);
                segments.add(ePackageName);
                segments.add(eEnumName);
                if (!(ctx.getChild(4) instanceof ErrorNode)) {
                    segments.add(eEnumLiteralName);
                }
                toPush = this.builder.errorEnumLiteral(false, segments.toArray(new String[segments.size()]));
                if (segments.size() == 3) {
                    this.pushError((Error)((Object)toPush), String.format(INVALID_ENUM_LITERAL, "no literal registered with this name"));
                } else {
                    this.pushError((Error)((Object)toPush), String.format(INVALID_ENUM_LITERAL, "missing literal name"));
                }
            } else {
                toPush = this.builder.enumLiteral(eEnumLiterals.iterator().next());
                this.push(toPush);
                if (eEnumLiterals.size() > 1) {
                    this.diagnosticStack.push((Diagnostic)new BasicDiagnostic(2, PLUGIN_ID, 0, String.format(AMBIGUOUS_ENUM_LITERAL, eEnumLiteralName, eEnumName, ePackageName), new Object[]{startPosition, stopPosition}));
                }
            }
            this.startPositions.put(toPush, startPosition);
            this.endPositions.put(toPush, stopPosition);
        }
    }

    @Override
    public void exitErrorEnumLit(QueryParser.ErrorEnumLitContext ctx) {
        if (this.errorRule == -1) {
            String ePackageName = ctx.getChild(0).getText();
            String eEnumName = ctx.getChild(2).getText();
            ErrorEnumLiteral errorEnumLiteral = this.builder.errorEnumLiteral(true, ePackageName, eEnumName);
            this.pushError(errorEnumLiteral, String.format(INVALID_ENUM_LITERAL, "':' instead of '::'"));
            this.startPositions.put(errorEnumLiteral, ctx.start.getStartIndex());
            this.endPositions.put(errorEnumLiteral, ctx.stop.getStopIndex() + 1);
        } else {
            this.errorRule = -1;
        }
    }

    @Override
    public void exitClassifierType(QueryParser.ClassifierTypeContext ctx) {
        if (this.errorRule == -1) {
            Literal toPush;
            String eClassName;
            String ePackageName = ctx.getChild(0).getText();
            Integer startPosition = ctx.start.getStartIndex();
            Integer stopPosition = ctx.stop.getStopIndex() + 1;
            Collection<Object> type = Collections.emptySet();
            if (ctx.getChild(2) == null || ctx.getChild(2) instanceof ErrorNode) {
                eClassName = null;
                type = Collections.emptySet();
            } else {
                eClassName = ctx.getChild(2).getText();
                type = this.environment.getEPackageProvider().getTypes(ePackageName, eClassName);
            }
            if (type.size() == 0) {
                ArrayList<String> segments = new ArrayList<String>(2);
                segments.add(ePackageName);
                if (eClassName != null) {
                    segments.add(eClassName);
                }
                toPush = this.builder.errorEClassifierTypeLiteral(false, segments.toArray(new String[segments.size()]));
                this.pushError((Error)((Object)toPush), String.format(INVALID_TYPE_LITERAL, ctx.getText()));
            } else {
                toPush = this.builder.typeLiteral(type);
                this.push(toPush);
                if (type.size() > 1) {
                    this.diagnosticStack.push((Diagnostic)new BasicDiagnostic(2, PLUGIN_ID, 0, String.format(AMBIGUOUS_TYPE_LITERAL, eClassName, ePackageName), new Object[]{startPosition, stopPosition}));
                }
            }
            this.startPositions.put(toPush, startPosition);
            this.endPositions.put(toPush, stopPosition);
        }
    }

    @Override
    public void exitErrorClassifierType(QueryParser.ErrorClassifierTypeContext ctx) {
        String ePackageName = ctx.getChild(0).getText();
        ErrorEClassifierTypeLiteral errorTypeLiteral = this.builder.errorEClassifierTypeLiteral(true, ePackageName);
        this.pushError(errorTypeLiteral, String.format(INVALID_TYPE_LITERAL, ctx.getText()));
        this.startPositions.put(errorTypeLiteral, ctx.start.getStartIndex());
        this.endPositions.put(errorTypeLiteral, ctx.stop.getStopIndex() + 1);
    }

    public ANTLRErrorListener getErrorListener() {
        return this.errorListener;
    }

    @Override
    public void exitNullLit(QueryParser.NullLitContext ctx) {
        NullLiteral nullLiteral = this.builder.nullLiteral();
        this.startPositions.put(nullLiteral, ctx.start.getStartIndex());
        this.endPositions.put(nullLiteral, ctx.stop.getStopIndex() + 1);
        this.push(nullLiteral);
    }

    @Override
    public void exitExplicitSetLit(QueryParser.ExplicitSetLitContext ctx) {
        SetInExtensionLiteral setInExtension = this.builder.setInExtension(this.getExpressions(ctx));
        this.startPositions.put(setInExtension, ctx.start.getStartIndex());
        this.endPositions.put(setInExtension, ctx.stop.getStopIndex() + 1);
        this.push(setInExtension);
    }

    private List<Expression> getExpressions(QueryParser.LiteralContext ctx) {
        int nbExpressions = (ctx.getChild(1).getChildCount() + 1) / 2;
        Expression[] expressions = new Expression[nbExpressions];
        int i = nbExpressions - 1;
        while (i >= 0) {
            expressions[i] = this.popExpression();
            --i;
        }
        return Arrays.asList(expressions);
    }

    @Override
    public void exitExplicitSeqLit(QueryParser.ExplicitSeqLitContext ctx) {
        SequenceInExtensionLiteral sequenceInExtension = this.builder.sequenceInExtension(this.getExpressions(ctx));
        this.startPositions.put(sequenceInExtension, ctx.start.getStartIndex());
        this.endPositions.put(sequenceInExtension, ctx.stop.getStopIndex() + 1);
        this.push(sequenceInExtension);
    }

    @Override
    public void exitConditional(QueryParser.ConditionalContext ctx) {
        Conditional conditional;
        Expression falseBranch;
        Expression trueBranch;
        Expression predicate;
        int count = ctx.getChildCount();
        if (count <= 3) {
            predicate = this.popExpression();
            trueBranch = null;
            falseBranch = null;
        } else if (count <= 5) {
            trueBranch = this.popExpression();
            predicate = this.popExpression();
            falseBranch = null;
        } else {
            falseBranch = this.popExpression();
            trueBranch = this.popExpression();
            predicate = this.popExpression();
        }
        if (this.errorRule == 1 || count == 7 && ctx.getChild(6) instanceof ErrorNode) {
            conditional = this.builder.errorConditional(predicate, trueBranch, falseBranch);
            this.errorRule = -1;
            this.pushError((Error)((Object)conditional), "incomplet conditional");
        } else {
            conditional = this.builder.conditional(predicate, trueBranch, falseBranch);
            this.push(conditional);
        }
        this.startPositions.put(conditional, ctx.start.getStartIndex());
        this.endPositions.put(conditional, ctx.stop.getStopIndex() + 1);
    }

    @Override
    public void exitBinding(QueryParser.BindingContext ctx) {
        if (this.errorRule != 2) {
            String variable = ctx.getChild(0).getText();
            Expression expression = this.popExpression();
            TypeLiteral type = ctx.getChildCount() == 5 ? this.popTypeLiteral() : null;
            Binding binding = this.builder.binding(variable, type, expression);
            this.startPositions.put(binding, ctx.start.getStartIndex());
            this.endPositions.put(binding, ctx.stop.getStopIndex() + 1);
            this.push(binding);
        } else {
            this.errorRule = -1;
        }
    }

    @Override
    public void exitLetExpr(QueryParser.LetExprContext ctx) {
        Binding[] bindings;
        Expression body;
        if (!(ctx.getChild(ctx.getChildCount() - 1) instanceof QueryParser.ExpressionContext)) {
            this.popErrorExpression();
            body = this.builder.errorExpression();
            this.startPositions.put(body, ctx.stop.getStopIndex() + 1);
            this.endPositions.put(body, ctx.stop.getStopIndex() + 1);
            ArrayList<Binding> bindingList = new ArrayList<Binding>();
            while (!this.stack.isEmpty() && this.stack.peek() instanceof Binding) {
                bindingList.add(this.popBinding());
            }
            bindings = bindingList.toArray(new Binding[bindingList.size()]);
        } else {
            body = this.popExpression();
            int bindingNumber = 1 + (ctx.getChildCount() - 3) / 2;
            bindings = new Binding[bindingNumber];
            int i = bindingNumber - 1;
            while (i >= 0) {
                bindings[i] = this.popBinding();
                --i;
            }
        }
        Let let = this.builder.let(body, bindings);
        this.startPositions.put(let, ctx.start.getStartIndex());
        this.endPositions.put(let, ctx.stop.getStopIndex() + 1);
        this.push(let);
    }

    @Override
    public void exitClassifierSetType(QueryParser.ClassifierSetTypeContext ctx) {
        int nbTypes = (ctx.getChildCount() + 1) / 2 - 1;
        TypeLiteral[] types = new TypeLiteral[nbTypes];
        int i = nbTypes - 1;
        while (i >= 0) {
            types[i] = this.popTypeLiteral();
            --i;
        }
        TypeSetLiteral classifierSetType = this.builder.typeSetLiteral(Arrays.asList(types));
        this.startPositions.put(classifierSetType, ctx.start.getStartIndex());
        this.endPositions.put(classifierSetType, ctx.stop.getStopIndex() + 1);
        this.push(classifierSetType);
    }

    private final class QueryErrorListener
    extends BaseErrorListener {
        private static final String MISSING_EXPRESSION = "missing expression";

        private QueryErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            if (e != null) {
                if (e.getCtx() instanceof QueryParser.IterationCallContext) {
                    this.iterationCallContextError(e);
                } else if (e.getCtx() instanceof QueryParser.TypeLiteralContext) {
                    this.typeLiteralContextError(offendingSymbol, msg, e);
                } else if (e.getCtx() instanceof QueryParser.LiteralContext) {
                    this.literalContextError(offendingSymbol, msg, e);
                } else if (e.getCtx() instanceof QueryParser.ClassifierTypeRuleContext) {
                    this.classifierTypeRuleContextError(offendingSymbol, msg, e);
                } else if (e.getCtx() instanceof QueryParser.VariableDefinitionContext) {
                    this.variableDefinitionContextError(offendingSymbol, e);
                } else if (e.getCtx() instanceof QueryParser.CallExpContext) {
                    this.callExpContextError(offendingSymbol, e);
                } else if (e.getCtx() instanceof QueryParser.NavigationSegmentContext) {
                    this.navigationSegmentContextError(offendingSymbol);
                } else if (e.getCtx() instanceof QueryParser.BindingContext) {
                    this.bindingContextError(offendingSymbol, e);
                } else if (e.getCtx() instanceof QueryParser.ConditionalContext) {
                    AstBuilderListener.this.errorRule = 1;
                } else if (!(e.getCtx() instanceof QueryParser.ParenContext)) {
                    this.defaultError(offendingSymbol, msg, e);
                }
            } else if (recognizer instanceof QueryParser) {
                this.noRecognitionException(recognizer, offendingSymbol, msg);
            } else {
                QueryParser parser = (QueryParser)recognizer;
                Integer startPosition = ((QueryParser.EnumLitContext)parser.getContext()).start.getStartIndex();
                Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
                AstBuilderListener.this.diagnosticStack.push(new BasicDiagnostic(2, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[]{startPosition, endPosition}));
            }
        }

        private void classifierTypeRuleContextError(Object offendingSymbol, String msg, RecognitionException e) {
            QueryParser.ClassifierTypeRuleContext ctx = (QueryParser.ClassifierTypeRuleContext)e.getCtx();
            Integer startPosition = ctx.start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            if (e.getCtx().getParent().getParent() instanceof QueryParser.VariableDefinitionContext) {
                AstBuilderListener.this.errorRule = 1;
                String variableName = e.getCtx().getParent().getChild(0).getText();
                ErrorEClassifierTypeLiteral errorTypeLiteral = ctx.getChildCount() > 0 ? AstBuilderListener.this.builder.errorEClassifierTypeLiteral(false, ctx.getChild(0).getText()) : AstBuilderListener.this.builder.errorEClassifierTypeLiteral(false, new String[0]);
                AstBuilderListener.this.startPositions.put(errorTypeLiteral, startPosition);
                AstBuilderListener.this.endPositions.put(errorTypeLiteral, endPosition);
                AstBuilderListener.this.diagnostics.add(new BasicDiagnostic(4, AstBuilderListener.PLUGIN_ID, 0, String.format(AstBuilderListener.INVALID_TYPE_LITERAL, ctx.getText()), new Object[]{errorTypeLiteral}));
                AstBuilderListener.this.errors.add(errorTypeLiteral);
                Expression variableExpression = AstBuilderListener.this.popExpression();
                VariableDeclaration variableDeclaration = AstBuilderListener.this.builder.variableDeclaration(variableName, errorTypeLiteral, variableExpression);
                AstBuilderListener.this.startPositions.put(variableDeclaration, startPosition);
                AstBuilderListener.this.endPositions.put(variableDeclaration, endPosition);
                AstBuilderListener.this.push(variableDeclaration);
                ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
                AstBuilderListener.this.startPositions.put(errorExpression, endPosition);
                AstBuilderListener.this.endPositions.put(errorExpression, endPosition);
            } else {
                AstBuilderListener.this.errorRule = 13;
                ErrorEClassifierTypeLiteral errorTypeLiteral = ctx.getChildCount() > 0 ? AstBuilderListener.this.builder.errorEClassifierTypeLiteral(false, ctx.getChild(0).getText()) : AstBuilderListener.this.builder.errorEClassifierTypeLiteral(false, new String[0]);
                AstBuilderListener.this.startPositions.put(errorTypeLiteral, startPosition);
                AstBuilderListener.this.endPositions.put(errorTypeLiteral, endPosition);
                AstBuilderListener.this.pushError(errorTypeLiteral, "missing classifier literal");
            }
        }

        private void iterationCallContextError(RecognitionException e) {
            if (e.getCtx().getChildCount() == 0) {
                AstBuilderListener.this.errorRule = 1;
                ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
                Integer position = ((QueryParser.IterationCallContext)e.getCtx()).start.getStartIndex();
                AstBuilderListener.this.startPositions.put(errorExpression, position);
                AstBuilderListener.this.endPositions.put(errorExpression, position);
            }
        }

        private void typeLiteralContextError(Object offendingSymbol, String msg, RecognitionException e) {
            Integer startPosition = ((QueryParser.TypeLiteralContext)e.getCtx()).start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            if (e.getCtx().getParent() instanceof QueryParser.VariableDefinitionContext) {
                AstBuilderListener.this.errorRule = 1;
                String variableName = e.getCtx().getParent().getChild(0).getText();
                ErrorTypeLiteral type = AstBuilderListener.this.builder.errorTypeLiteral(false, new String[0]);
                AstBuilderListener.this.startPositions.put(type, startPosition);
                AstBuilderListener.this.endPositions.put(type, endPosition);
                AstBuilderListener.this.diagnostics.add(new BasicDiagnostic(4, AstBuilderListener.PLUGIN_ID, 0, String.format(AstBuilderListener.INVALID_TYPE_LITERAL, msg), new Object[]{type}));
                AstBuilderListener.this.errors.add(type);
                Expression variableExpression = AstBuilderListener.this.popExpression();
                VariableDeclaration variableDeclaration = AstBuilderListener.this.builder.variableDeclaration(variableName, type, variableExpression);
                AstBuilderListener.this.startPositions.put(variableDeclaration, startPosition);
                AstBuilderListener.this.endPositions.put(variableDeclaration, endPosition);
                AstBuilderListener.this.push(variableDeclaration);
                ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
                AstBuilderListener.this.startPositions.put(errorExpression, startPosition);
                AstBuilderListener.this.endPositions.put(errorExpression, endPosition);
            } else if (AstBuilderListener.this.stack.isEmpty() || !(AstBuilderListener.this.stack.peek() instanceof TypeLiteral)) {
                AstBuilderListener.this.errorRule = 12;
                ErrorTypeLiteral errorTypeLiteral = AstBuilderListener.this.builder.errorTypeLiteral(false, new String[0]);
                AstBuilderListener.this.startPositions.put(errorTypeLiteral, startPosition);
                AstBuilderListener.this.endPositions.put(errorTypeLiteral, endPosition);
                AstBuilderListener.this.pushError(errorTypeLiteral, String.format(AstBuilderListener.INVALID_TYPE_LITERAL, msg));
            } else {
                AstBuilderListener.this.diagnosticStack.push(new BasicDiagnostic(2, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[]{startPosition, endPosition}));
            }
        }

        private void literalContextError(Object offendingSymbol, String msg, RecognitionException e) {
            QueryParser.LiteralContext ctx = (QueryParser.LiteralContext)e.getCtx();
            Integer startPosition = ctx.start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            String ePackage = ctx.getParent().getStart().getText();
            AstBuilderListener.this.errorRule = 12;
            if (ctx.getChildCount() == 4) {
                String eEnumName = ctx.getChild(2).getText();
                ErrorEnumLiteral errorEnumLiteral = AstBuilderListener.this.builder.errorEnumLiteral(false, ePackage, eEnumName);
                AstBuilderListener.this.startPositions.put(errorEnumLiteral, startPosition);
                AstBuilderListener.this.endPositions.put(errorEnumLiteral, endPosition);
                AstBuilderListener.this.pushError(errorEnumLiteral, String.format(AstBuilderListener.INVALID_ENUM_LITERAL, msg));
            } else {
                ErrorTypeLiteral errorTypeLiteral = AstBuilderListener.this.builder.errorTypeLiteral(false, ePackage);
                AstBuilderListener.this.startPositions.put(errorTypeLiteral, startPosition);
                AstBuilderListener.this.endPositions.put(errorTypeLiteral, endPosition);
                AstBuilderListener.this.pushError(errorTypeLiteral, String.format(AstBuilderListener.INVALID_TYPE_LITERAL, msg));
            }
        }

        private void variableDefinitionContextError(Object offendingSymbol, RecognitionException e) {
            Integer startPosition = ((QueryParser.VariableDefinitionContext)e.getCtx()).start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            if (e.getCtx().getChildCount() > 0) {
                TypeLiteral type;
                AstBuilderListener.this.errorRule = 1;
                String variableName = e.getCtx().getChild(0).getText();
                if (e.getCtx().getChildCount() > 2) {
                    type = AstBuilderListener.this.popTypeLiteral();
                    AstBuilderListener.this.endPositions.put(type, endPosition);
                } else {
                    type = null;
                }
                Expression variableExpression = AstBuilderListener.this.popExpression();
                ErrorVariableDeclaration errorVariableDeclaration = AstBuilderListener.this.builder.errorVariableDeclaration(variableName, type, variableExpression);
                AstBuilderListener.this.startPositions.put(errorVariableDeclaration, startPosition);
                AstBuilderListener.this.endPositions.put(errorVariableDeclaration, endPosition);
                AstBuilderListener.this.pushError(errorVariableDeclaration, "incomplete variable definition");
            } else {
                Expression variableExpression = AstBuilderListener.this.popExpression();
                AstBuilderListener.this.errorRule = 10;
                ErrorVariableDeclaration errorVariableDeclaration = AstBuilderListener.this.builder.errorVariableDeclaration(null, null, variableExpression);
                AstBuilderListener.this.startPositions.put(errorVariableDeclaration, startPosition);
                AstBuilderListener.this.endPositions.put(errorVariableDeclaration, endPosition);
                AstBuilderListener.this.pushError(errorVariableDeclaration, "missing variable declaration");
            }
            if (((Token)offendingSymbol).getText().isEmpty() || ")".equals(((Token)offendingSymbol).getText())) {
                ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                if (((Token)offendingSymbol).getStartIndex() == ((Token)offendingSymbol).getStopIndex()) {
                    AstBuilderListener.this.startPositions.put(errorExpression, endPosition - 1);
                    AstBuilderListener.this.endPositions.put(errorExpression, endPosition - 1);
                } else {
                    AstBuilderListener.this.startPositions.put(errorExpression, endPosition);
                    AstBuilderListener.this.endPositions.put(errorExpression, endPosition);
                }
                AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
            }
        }

        private void callExpContextError(Object offendingSymbol, RecognitionException e) {
            ErrorCall errorCollectionCall;
            Expression receiver;
            AstBuilderListener.this.errorRule = 5;
            String name = e.getCtx().getChildCount() > 0 ? e.getCtx().getChild(0).getText() : null;
            if (e.getCtx().getChildCount() == 3) {
                int argc = AstBuilderListener.this.getNumberOfArgs(e.getCtx().getChild(2).getChildCount());
                Expression[] args = new Expression[argc];
                int i = argc - 1;
                while (i >= 0) {
                    args[i] = AstBuilderListener.this.popExpression();
                    --i;
                }
                receiver = args[0];
                errorCollectionCall = AstBuilderListener.this.builder.errorCall(name, false, args);
            } else {
                receiver = AstBuilderListener.this.popExpression();
                errorCollectionCall = AstBuilderListener.this.builder.errorCall(null, false, receiver);
            }
            AstBuilderListener.this.startPositions.put(errorCollectionCall, (Integer)AstBuilderListener.this.startPositions.get(receiver));
            AstBuilderListener.this.endPositions.put(errorCollectionCall, ((Token)offendingSymbol).getStopIndex() + 1);
            AstBuilderListener.this.pushError(errorCollectionCall, "missing collection service call");
        }

        private void navigationSegmentContextError(Object offendingSymbol) {
            Expression receiver = AstBuilderListener.this.popExpression();
            ErrorCall errorCall = AstBuilderListener.this.builder.errorCall(AstBuilderListener.FEATURE_ACCESS_SERVICE_NAME, false, receiver);
            errorCall.setType(CallType.CALLORAPPLY);
            AstBuilderListener.this.startPositions.put(errorCall, (Integer)AstBuilderListener.this.startPositions.get(receiver));
            AstBuilderListener.this.endPositions.put(errorCall, ((Token)offendingSymbol).getStopIndex() + 1);
            AstBuilderListener.this.pushError(errorCall, "missing feature access or service call");
        }

        private void bindingContextError(Object offendingSymbol, RecognitionException e) {
            TypeLiteral type;
            String name;
            AstBuilderListener.this.errorRule = 2;
            if (e.getCtx().getChildCount() > 0 && !"in".equals(e.getCtx().getChild(0).getText())) {
                name = e.getCtx().getChild(0).getText();
                type = e.getCtx().getChildCount() == 3 ? AstBuilderListener.this.popTypeLiteral() : null;
            } else {
                name = null;
                type = null;
            }
            ErrorBinding errorBinding = AstBuilderListener.this.builder.errorBinding(name, type);
            AstBuilderListener.this.startPositions.put(errorBinding, ((Token)offendingSymbol).getStopIndex() + 1);
            AstBuilderListener.this.endPositions.put(errorBinding, ((Token)offendingSymbol).getStopIndex() + 1);
            AstBuilderListener.this.pushError(errorBinding, "invalid variable declaration in let");
        }

        private void defaultError(Object offendingSymbol, String msg, RecognitionException e) {
            if (offendingSymbol == null && e.getCtx() == null) {
                AstBuilderListener.this.diagnostics.add(new BasicDiagnostic(4, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[0]));
            } else {
                switch (e.getCtx().getRuleIndex()) {
                    case 1: {
                        AstBuilderListener.this.errorRule = 1;
                        ErrorExpression errorExpression = AstBuilderListener.this.builder.errorExpression();
                        Integer position = ((ParserRuleContext)e.getCtx()).start.getStartIndex();
                        AstBuilderListener.this.startPositions.put(errorExpression, position);
                        AstBuilderListener.this.endPositions.put(errorExpression, position);
                        AstBuilderListener.this.pushError(errorExpression, MISSING_EXPRESSION);
                        break;
                    }
                }
            }
        }

        private void noRecognitionException(Recognizer<?, ?> recognizer, Object offendingSymbol, String msg) {
            QueryParser parser = (QueryParser)recognizer;
            Integer startPosition = parser.getContext().start.getStartIndex();
            Integer endPosition = ((Token)offendingSymbol).getStopIndex() + 1;
            AstBuilderListener.this.diagnosticStack.push(new BasicDiagnostic(2, AstBuilderListener.PLUGIN_ID, 0, msg, new Object[]{startPosition, endPosition}));
        }
    }
}

