/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.options;

import java.util.EnumSet;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.util.FixedLayoutProvider;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class FixedLayouterOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.fixed";
    private static final ElkPadding PADDING_DEFAULT = new ElkPadding(15.0);
    public static final IProperty<ElkPadding> PADDING = new Property(CoreOptions.PADDING, (Object)PADDING_DEFAULT);
    public static final IProperty<KVector> POSITION = CoreOptions.POSITION;
    public static final IProperty<KVectorChain> BEND_POINTS = CoreOptions.BEND_POINTS;
    public static final IProperty<EnumSet<SizeConstraint>> NODE_SIZE_CONSTRAINTS = CoreOptions.NODE_SIZE_CONSTRAINTS;
    public static final IProperty<KVector> NODE_SIZE_MINIMUM = CoreOptions.NODE_SIZE_MINIMUM;
    public static final IProperty<Boolean> NODE_SIZE_FIXED_GRAPH_SIZE = CoreOptions.NODE_SIZE_FIXED_GRAPH_SIZE;

    @Override
    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Fixed").description("Keeps the current layout as it is, without any automatic modification. Optional coordinates can be given for nodes and edge bend points.").providerFactory(new FixedFactory()).melkBundleName("ELK").definingBundleId("org.eclipse.elk.core").create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", PADDING_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.position", POSITION.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.bendPoints", BEND_POINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.constraints", NODE_SIZE_CONSTRAINTS.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.minimum", NODE_SIZE_MINIMUM.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.nodeSize.fixedGraphSize", NODE_SIZE_FIXED_GRAPH_SIZE.getDefault());
    }

    public static class FixedFactory
    implements IFactory<AbstractLayoutProvider> {
        @Override
        public AbstractLayoutProvider create() {
            FixedLayoutProvider provider = new FixedLayoutProvider();
            provider.initialize("");
            return provider;
        }

        @Override
        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

