/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.tabprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.eef.EEFViewDescription;
import org.eclipse.eef.core.api.EEFView;
import org.eclipse.eef.core.api.EEFViewFactory;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.IEEFDomainClassTester;
import org.eclipse.eef.core.api.InputDescriptor;
import org.eclipse.eef.ide.ui.properties.api.EEFTabDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptor;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptorProvider;
import org.eclipse.eef.properties.ui.api.IEEFTabbedPropertySheetPageContributor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.common.interpreter.api.VariableManagerFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.core.api.OverridesProvider;
import org.eclipse.sirius.properties.core.api.SiriusDomainClassTester;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.sirius.properties.core.api.SiriusInterpreter;
import org.eclipse.sirius.properties.core.api.ViewDescriptionConverter;
import org.eclipse.sirius.properties.core.api.ViewDescriptionPreprocessor;
import org.eclipse.sirius.properties.defaultrules.api.DefaultRulesProvider;
import org.eclipse.sirius.ui.properties.internal.SiriusUIPropertiesPlugin;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.ui.IWorkbenchPart;

public class SiriusTabDescriptorProvider
implements IEEFTabDescriptorProvider {
    public Collection<IEEFTabDescriptor> get(IWorkbenchPart part, ISelection selection, IEEFTabbedPropertySheetPageContributor contributor) {
        SiriusInputDescriptor sid;
        IStructuredSelection structuredSelection;
        List objects;
        if (selection instanceof IStructuredSelection && (objects = (structuredSelection = (IStructuredSelection)selection).toList()).size() > 0 && (sid = new SiriusInputDescriptor(objects.get(0), objects)).getSemanticElement() != null) {
            return this.getTabDescriptors(sid);
        }
        return new ArrayList<IEEFTabDescriptor>();
    }

    private Collection<IEEFTabDescriptor> getTabDescriptors(SiriusInputDescriptor input) {
        Option session = input.getFullContext().getSession();
        if (session.some()) {
            List<PageDescription> effectivePageDescriptions = this.computeEffectiveDescription(input, (Session)session.get());
            return this.getTabDescriptors((Session)session.get(), input, effectivePageDescriptions);
        }
        return Collections.emptyList();
    }

    private Collection<IEEFTabDescriptor> getTabDescriptors(Session session, SiriusInputDescriptor input, List<PageDescription> effectivePageDescriptions) {
        EEFViewDescription viewDescription = new ViewDescriptionConverter(effectivePageDescriptions).convert(input);
        EEFView eefView = this.createEEFView(session, input, viewDescription);
        return eefView.getPages().stream().map(EEFTabDescriptor::new).collect(Collectors.toList());
    }

    private EEFView createEEFView(Session session, SiriusInputDescriptor input, EEFViewDescription viewDescription) {
        IVariableManager variableManager = new VariableManagerFactory().createVariableManager();
        variableManager.put("self", (Object)input.getSemanticElement());
        variableManager.put("input", (Object)input);
        EditingContextAdapter editingContextAdapter = SiriusUIPropertiesPlugin.getPlugin().getEditingContextAdapter(session);
        EEFView eefView = new EEFViewFactory().createEEFView(viewDescription, variableManager, (IInterpreter)new SiriusInterpreter(session), editingContextAdapter, (IEEFDomainClassTester)new SiriusDomainClassTester(session), (InputDescriptor)input);
        return eefView;
    }

    private List<PageDescription> computeEffectiveDescription(SiriusInputDescriptor input, Session session) {
        ViewExtensionDescription viewExtensionDescription2;
        Objects.requireNonNull(session);
        Set<ViewExtensionDescription> viewExtensionDescriptions = session.getSelectedViewpoints(true).stream().map(viewpoint -> new EObjectQuery((EObject)viewpoint).getFirstAncestorOfType(DescriptionPackage.Literals.GROUP)).filter(Option::some).map(Option::get).filter(Group.class::isInstance).map(Group.class::cast).flatMap(group -> group.getExtensions().stream()).filter(ViewExtensionDescription.class::isInstance).map(ViewExtensionDescription.class::cast).collect(Collectors.toSet());
        ArrayList<PageDescription> effectivePages = new ArrayList<PageDescription>();
        viewExtensionDescriptions.forEach(viewExtensionDescription -> {
            IVariableManager variableManager = new VariableManagerFactory().createVariableManager();
            variableManager.put("self", viewExtensionDescription);
            new ViewDescriptionPreprocessor(viewExtensionDescription).convert((IInterpreter)new SiriusInterpreter(session), variableManager, new OverridesProvider(session)).ifPresent(processedViewExtensionDescription -> processedViewExtensionDescription.getCategories().forEach(category -> {
                boolean bl = effectivePages.addAll((Collection<PageDescription>)category.getPages());
            }));
        });
        if (effectivePages.size() == 0 && (viewExtensionDescription2 = DefaultRulesProvider.INSTANCE.getDefaultRules()) != null) {
            viewExtensionDescription2.getCategories().forEach(category -> {
                boolean bl = effectivePages.addAll((Collection<PageDescription>)category.getPages());
            });
        }
        return effectivePages;
    }
}

