/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.tests.support.api.SiriusTestCase;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.DTreeItemContainer;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.business.api.command.TreeCommandFactoryService;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemCreationTool;
import org.eclipse.sirius.tree.ui.tools.internal.editor.provider.DTreeItemEditingSupport;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;

public abstract class TreeTestCase
extends SiriusTestCase {
    protected static final String CREATE_VIEW_MESSAGE = "create view from testcase";
    protected static final String THE_UNIT_TEST_DATA_SEEMS_INCORRECT = "The unit test data seems incorrect";
    protected static final String INIT_ERROR_MSG = "An error occurs during tests initialization";
    private ITreeCommandFactory treeCommandFactory;

    protected void setUp() throws Exception {
        super.setUp();
        SiriusEditPlugin.getPlugin().setUiCallback((UICallBack)new NoUICallback());
    }

    protected ITreeCommandFactory getCommandFactory() {
        if (this.treeCommandFactory == null) {
            this.treeCommandFactory = TreeCommandFactoryService.getInstance().getNewProvider().getCommandFactory(this.session.getTransactionalEditingDomain());
            this.treeCommandFactory.setModelAccessor(this.accessor);
        }
        return this.treeCommandFactory;
    }

    protected final boolean applyDeletionTool(DTreeElement element) {
        boolean result = false;
        Command cmd = this.getCommandFactory().buildDeleteTreeElement(element);
        result = cmd.canExecute();
        this.session.getTransactionalEditingDomain().getCommandStack().execute(cmd);
        return result;
    }

    protected final boolean applyCreationTool(DTreeItemContainer lineContainer, EObject semanticCurrentElement, TreeItemCreationTool tool) {
        boolean result = false;
        Command cmd = this.getCommandFactory().buildCreateLineCommandFromTool(lineContainer, semanticCurrentElement, tool);
        result = cmd.canExecute();
        this.session.getTransactionalEditingDomain().getCommandStack().execute(cmd);
        return result;
    }

    protected final boolean applyOperationAction(OperationAction operationAction, DTreeItem treeItem) {
        boolean result = false;
        Command cmd = this.getCommandFactory().buildOperationActionFromTool(operationAction, treeItem);
        result = cmd.canExecute();
        this.session.getTransactionalEditingDomain().getCommandStack().execute(cmd);
        return result;
    }

    protected final boolean applyCreationDescriptionTool(RepresentationCreationDescription creationDescription, DTreeElement element, String representationName) {
        boolean result = false;
        CreateRepresentationCommand cmd = this.getCommandFactory().buildCreateRepresentationFromDescription(creationDescription, (DRepresentationElement)element, representationName);
        result = cmd.canExecute();
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)cmd);
        return result;
    }

    protected final boolean applyRefresh(DRepresentation representation) {
        boolean result = false;
        RefreshRepresentationsCommand command = new RefreshRepresentationsCommand(this.session.getTransactionalEditingDomain(), this.defaultProgress, new DRepresentation[]{representation});
        result = command.canExecute();
        this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
        return result;
    }

    protected void applyUndo() {
        this.session.getTransactionalEditingDomain().getCommandStack().undo();
    }

    protected void applyRedo() {
        this.session.getTransactionalEditingDomain().getCommandStack().redo();
    }

    protected TreeDescription find(String name) {
        for (RepresentationDescription next : ((Viewpoint)this.viewpoints.iterator().next()).getOwnedRepresentations()) {
            if (!(next instanceof TreeDescription) || !name.equals(((TreeDescription)next).getName())) continue;
            return (TreeDescription)next;
        }
        return null;
    }

    protected final boolean applyDirectEditTool(DTree tree, DTreeItem element, String value) {
        AbstractDTreeEditor editor = (AbstractDTreeEditor)EclipseUIUtil.getActiveEditor();
        TreeViewer viewer = (TreeViewer)editor.getViewer();
        DTreeItemEditingSupport support = new DTreeItemEditingSupport(viewer, this.session.getTransactionalEditingDomain(), this.accessor, this.getCommandFactory(), editor);
        Class<DTreeItemEditingSupport> supportClass = DTreeItemEditingSupport.class;
        try {
            Method canEdit = supportClass.getDeclaredMethod("canEdit", Object.class);
            Method setValue = supportClass.getDeclaredMethod("setValue", Object.class, Object.class);
            canEdit.setAccessible(true);
            setValue.setAccessible(true);
            if (((Boolean)canEdit.invoke((Object)support, element)).booleanValue()) {
                setValue.invoke((Object)support, element, value);
                return true;
            }
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException("No Edition tool defined on TreeItem '" + element.getName() + "'");
        }
    }

    protected final DRepresentationElement getRepresentationElementWithName(DRepresentation representation, String representationElementName) {
        for (DRepresentationElement element : representation.getRepresentationElements()) {
            if (!representationElementName.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    protected void tearDown() throws Exception {
        TestsUtil.synchronizationWithUIThread();
        this.treeCommandFactory = null;
        super.tearDown();
    }
}

