/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.tools.internal.menu;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.editor.properties.api.DefaultWidgetDescription;
import org.eclipse.sirius.editor.properties.api.IDefaultWidgetDescriptionFactory;
import org.eclipse.sirius.editor.properties.internal.Messages;
import org.eclipse.sirius.editor.properties.internal.SiriusEditorPropertiesPlugin;
import org.eclipse.sirius.editor.properties.tools.internal.menu.CreateWidgetForAllFeaturesDescriptor;
import org.eclipse.sirius.editor.tools.api.menu.AbstractUndoRecordingCommand;
import org.eclipse.sirius.properties.ContainerDescription;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.core.internal.EditSupportSpec;

public class CreateWidgetForAllFeaturesCommand
extends AbstractUndoRecordingCommand {
    private CreateWidgetForAllFeaturesDescriptor descriptor;

    public CreateWidgetForAllFeaturesCommand(ResourceSet resourceSet, CreateWidgetForAllFeaturesDescriptor descriptor) {
        super(resourceSet);
        this.descriptor = descriptor;
    }

    protected void doExecute() {
        this.descriptor.getDomainClass().getEAllStructuralFeatures().stream().filter(EditSupportSpec::shouldAppearInPropertySheet).forEach(eStructuralFeature -> {
            List<IDefaultWidgetDescriptionFactory> factories = SiriusEditorPropertiesPlugin.getPlugin().getDefaultWidgetDescriptionFactory(this.descriptor.getDomainClass(), (EStructuralFeature)eStructuralFeature);
            if (factories.size() >= 1) {
                IDefaultWidgetDescriptionFactory factory = factories.get(0);
                DefaultWidgetDescription defaultWidgetDescription = factory.create(this.descriptor.getDomainClass(), (EStructuralFeature)eStructuralFeature);
                EObject controlsContainerDescription = this.descriptor.getControlsContainerDescription();
                if (controlsContainerDescription instanceof GroupDescription) {
                    ((GroupDescription)controlsContainerDescription).getControls().add((Object)defaultWidgetDescription.getWidgetDescription());
                } else if (controlsContainerDescription instanceof ContainerDescription) {
                    ((ContainerDescription)controlsContainerDescription).getControls().add((Object)defaultWidgetDescription.getWidgetDescription());
                }
            }
        });
    }

    protected String getText() {
        return MessageFormat.format(Messages.CreateWidgetForAllFeaturesCommand_text, this.descriptor.getDomainClass().getEPackage().getName(), this.descriptor.getDomainClass().getName());
    }
}

