/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.topdownpacking;

import java.util.List;
import org.eclipse.elk.alg.topdownpacking.GridElkNode;
import org.eclipse.elk.alg.topdownpacking.TopdownPackingPhases;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class BottomRowEqualWhitespaceEliminator
implements ILayoutPhase<TopdownPackingPhases, GridElkNode> {
    public void process(GridElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Whitespace elimination", 1.0f);
        progressMonitor.log((Object)("Whitespace elimination began for node " + layoutGraph.getIdentifier()));
        if (layoutGraph.getWidth() == 0.0 || layoutGraph.getColumns() == 0) {
            progressMonitor.log((Object)"Parent node has no width, skipping phase");
            progressMonitor.done();
            return;
        }
        ElkPadding padding = (ElkPadding)layoutGraph.getProperty(CoreOptions.PADDING);
        int i = 0;
        while (i < layoutGraph.getRows()) {
            List<ElkNode> row = layoutGraph.getRow(i);
            ElkNode last = null;
            int lastIndex = row.size();
            while (last == null) {
                last = row.get(--lastIndex);
            }
            double rightBorder = last.getX() + last.getWidth();
            if (rightBorder + padding.right < layoutGraph.getWidth()) {
                progressMonitor.log((Object)("Eliminate white space in row " + i));
                double extraSpace = layoutGraph.getWidth() - (rightBorder + padding.right);
                double extraSpacePerNode = extraSpace / (double)(lastIndex + 1);
                double accumulatedShift = 0.0;
                int j = 0;
                while (j <= lastIndex) {
                    ElkNode node = row.get(j);
                    node.setX(node.getX() + accumulatedShift);
                    node.setWidth(node.getWidth() + extraSpacePerNode);
                    accumulatedShift += extraSpacePerNode;
                    ++j;
                }
            }
            ++i;
        }
        List<ElkNode> col = layoutGraph.getColumn(0);
        ElkNode last = col.get(col.size() - 1);
        double bottomBorder = last.getY() + last.getHeight();
        double extraSpace = layoutGraph.getHeight() - (bottomBorder + padding.bottom);
        double extraSpacePerNode = extraSpace / (double)(col.size() + 1);
        double accumulatedShift = 0.0;
        progressMonitor.log((Object)"Eliminate vertical white space");
        if (bottomBorder + padding.bottom < layoutGraph.getHeight()) {
            int i2 = 0;
            while (i2 < layoutGraph.getRows()) {
                List<ElkNode> row = layoutGraph.getRow(i2);
                for (ElkNode node : row) {
                    if (node == null) break;
                    node.setY(node.getY() + accumulatedShift);
                    node.setHeight(node.getHeight() + extraSpacePerNode);
                    accumulatedShift += extraSpacePerNode;
                }
                ++i2;
            }
        }
        progressMonitor.logGraph((ElkNode)layoutGraph, "Graph after whitespace elimination");
        progressMonitor.done();
    }

    public LayoutProcessorConfiguration<TopdownPackingPhases, GridElkNode> getLayoutProcessorConfiguration(GridElkNode graph) {
        return LayoutProcessorConfiguration.create();
    }
}

