/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.clipboard;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.clipboard.core.AbstractClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.CopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.OverrideCopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.OverridePasteChildOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteChildOperation;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.tools.api.util.GMFNotationHelper;

public final class SiriusDefaultClipboardSupport
extends AbstractClipboardSupport {
    private static final SiriusDefaultClipboardSupport INSTANCE = new SiriusDefaultClipboardSupport();

    private SiriusDefaultClipboardSupport() {
    }

    public static SiriusDefaultClipboardSupport getInstance() {
        return INSTANCE;
    }

    public Collection getExcludedCopyObjects(Set eObjects) {
        return Collections.EMPTY_SET;
    }

    public boolean shouldOverrideCopyOperation(Collection eObjects, Map hintMap) {
        return true;
    }

    public boolean shouldOverrideChildPasteOperation(EObject parentElement, EObject childEObject) {
        return false;
    }

    public OverridePasteChildOperation getOverrideChildPasteOperation(PasteChildOperation overriddenChildPasteOperation) {
        return null;
    }

    public OverrideCopyOperation getOverrideCopyOperation(CopyOperation overriddenCopyOperation) {
        return new OverrideCopyOperation(overriddenCopyOperation){

            public String copy() throws Exception {
                this.keepNotes();
                if (this.getEObjects() == null || this.getEObjects().isEmpty()) {
                    return "";
                }
                return this.doCopy();
            }

            private void keepNotes() {
                boolean noteFound = false;
                for (View view : Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.getEObjects(), View.class))) {
                    if (!this.isNote(view)) {
                        this.getEObjects().remove(view);
                        continue;
                    }
                    noteFound = true;
                }
                if (!noteFound) {
                    this.getEObjects().clear();
                }
            }

            private boolean isNote(View view) {
                return view instanceof Node && GMFNotationHelper.isNote((Node)view);
            }
        };
    }
}

