/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.ui.layout;

import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.core.ui.rendering.GraphRenderingConfigurator;
import org.eclipse.elk.core.ui.rendering.LayoutGraphDialog;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class TextLayoutConnector
implements IDiagramLayoutConnector {
    public LayoutMapping buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        if (workbenchPart instanceof XtextEditor) {
            XtextEditor xtextEditor = (XtextEditor)workbenchPart;
            return (LayoutMapping)xtextEditor.getDocument().readOnly(resource -> {
                EObject content;
                EObject eObject = content = resource.getContents().isEmpty() ? null : (EObject)resource.getContents().get(0);
                if (content instanceof ElkNode) {
                    return this.buildLayoutGraph(xtextEditor, (ElkNode)content);
                }
                throw new IllegalArgumentException("Not supported by this layout connector: " + content);
            });
        }
        throw new IllegalArgumentException("Not supported by this layout connector: " + workbenchPart);
    }

    protected LayoutMapping buildLayoutGraph(XtextEditor xtextEditor, ElkNode rootNode) {
        LayoutMapping mapping = new LayoutMapping((IWorkbenchPart)xtextEditor);
        mapping.setParentElement((Object)rootNode);
        mapping.setLayoutGraph((ElkNode)EcoreUtil.copy((EObject)rootNode));
        return mapping;
    }

    public void applyLayout(LayoutMapping mapping, IPropertyHolder settings) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(() -> {
            EObject parentElement = (EObject)mapping.getParentElement();
            GraphRenderingConfigurator configurator = new GraphRenderingConfigurator(display);
            LayoutGraphDialog dialog = new LayoutGraphDialog(mapping.getLayoutGraph(), parentElement.eResource(), configurator, display.getActiveShell());
            dialog.open();
        });
    }
}

