/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.dialect.command;

import java.util.Collection;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class CopyRepresentationCommand
extends RecordingCommand {
    private Collection<DRepresentationDescriptor> representationDescriptors;
    private Session session;
    private String newName;

    public CopyRepresentationCommand(TransactionalEditingDomain domain, Collection<DRepresentationDescriptor> representationDescriptors, String newName, Session session) {
        super(domain, Messages.CopyRepresentationCommand_label);
        this.representationDescriptors = representationDescriptors;
        this.newName = newName;
        this.session = session;
    }

    protected void doExecute() {
        if (this.representationDescriptors == null || this.session == null) {
            return;
        }
        for (DRepresentationDescriptor representationDescriptor : this.representationDescriptors) {
            DialectManager.INSTANCE.copyRepresentation(representationDescriptor, this.getName(representationDescriptor), this.session, null);
        }
    }

    private String getName(DRepresentationDescriptor representationDescriptor) {
        if (this.representationDescriptors.size() == 1) {
            return this.newName;
        }
        return String.valueOf(this.newName) + " " + representationDescriptor.getName();
    }
}

