/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p2layers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.alg.common.networksimplex.NEdge;
import org.eclipse.elk.alg.common.networksimplex.NGraph;
import org.eclipse.elk.alg.common.networksimplex.NNode;
import org.eclipse.elk.alg.common.networksimplex.NetworkSimplex;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class NetworkSimplexLayerer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> BASELINE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P1_CYCLE_BREAKING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER).addBefore((Enum)LayeredPhases.P2_LAYERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LAYER_CONSTRAINT_PREPROCESSOR).addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LAYER_CONSTRAINT_POSTPROCESSOR);
    private LGraph layeredGraph;
    private List<LNode> componentNodes;
    private boolean[] nodeVisited;
    private static final int ITER_LIMIT_FACTOR = 4;

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return BASELINE_PROCESSING_CONFIGURATION;
    }

    private List<List<LNode>> connectedComponents(List<LNode> theNodes) {
        if (this.nodeVisited == null || this.nodeVisited.length < theNodes.size()) {
            this.nodeVisited = new boolean[theNodes.size()];
        } else {
            Arrays.fill(this.nodeVisited, false);
        }
        this.componentNodes = Lists.newArrayList();
        int counter = 0;
        for (LNode node : theNodes) {
            node.id = counter++;
        }
        LinkedList components = Lists.newLinkedList();
        for (LNode node : theNodes) {
            if (this.nodeVisited[node.id]) continue;
            this.connectedComponentsDFS(node);
            if (components.isEmpty() || ((List)components.getFirst()).size() < this.componentNodes.size()) {
                components.addFirst(this.componentNodes);
            } else {
                components.addLast(this.componentNodes);
            }
            this.componentNodes = Lists.newArrayList();
        }
        return components;
    }

    private void connectedComponentsDFS(LNode node) {
        this.nodeVisited[node.id] = true;
        this.componentNodes.add(node);
        for (LPort port : node.getPorts()) {
            for (LEdge edge : port.getConnectedEdges()) {
                LNode opposite = this.getOpposite(port, edge).getNode();
                if (this.nodeVisited[opposite.id]) continue;
                this.connectedComponentsDFS(opposite);
            }
        }
    }

    private NGraph initialize(List<LNode> theNodes) {
        HashMap nodeMap = Maps.newHashMap();
        NGraph graph = new NGraph();
        for (LNode lNode : theNodes) {
            NNode nNode = NNode.of().origin((Object)lNode).create(graph);
            nodeMap.put(lNode, nNode);
        }
        for (LNode lNode : theNodes) {
            for (LEdge lEdge : lNode.getOutgoingEdges()) {
                if (lEdge.isSelfLoop()) continue;
                NEdge.of((Object)((Object)lEdge)).weight((double)(1 * Math.max(1, (Integer)lEdge.getProperty(LayeredOptions.PRIORITY_SHORTNESS)))).delta(1).source((NNode)nodeMap.get((Object)lEdge.getSource().getNode())).target((NNode)nodeMap.get((Object)lEdge.getTarget().getNode())).create();
            }
        }
        return graph;
    }

    private void dispose() {
        this.componentNodes = null;
        this.layeredGraph = null;
        this.nodeVisited = null;
    }

    public void process(LGraph theLayeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Network simplex layering", 1.0f);
        this.layeredGraph = theLayeredGraph;
        int thoroughness = (Integer)theLayeredGraph.getProperty(LayeredOptions.THOROUGHNESS) * 4;
        List<LNode> theNodes = this.layeredGraph.getLayerlessNodes();
        if (theNodes.size() < 1) {
            monitor.done();
            return;
        }
        List<List<LNode>> connectedComponents = this.connectedComponents(theNodes);
        int[] previousLayeringNodeCounts = null;
        for (List<LNode> connComp : connectedComponents) {
            int iterLimit = thoroughness * (int)Math.sqrt(connComp.size());
            NGraph graph = this.initialize(connComp);
            NetworkSimplex.forGraph((NGraph)graph).withIterationLimit(iterLimit).withPreviousLayering(previousLayeringNodeCounts).withBalancing(true).execute(monitor.subTask(1.0f));
            List<Layer> layers = this.layeredGraph.getLayers();
            for (NNode nNode : graph.nodes) {
                while (layers.size() <= nNode.layer) {
                    layers.add(layers.size(), new Layer(this.layeredGraph));
                }
                LNode lNode = (LNode)((Object)nNode.origin);
                lNode.setLayer(layers.get(nNode.layer));
            }
            if (connectedComponents.size() <= 1) continue;
            previousLayeringNodeCounts = new int[this.layeredGraph.getLayers().size()];
            int layerIdx = 0;
            for (Layer l : this.layeredGraph) {
                previousLayeringNodeCounts[layerIdx++] = l.getNodes().size();
            }
        }
        theNodes.clear();
        this.dispose();
        monitor.done();
    }

    private LPort getOpposite(LPort port, LEdge edge) {
        if (((Object)((Object)edge.getSource())).equals((Object)port)) {
            return edge.getTarget();
        }
        if (((Object)((Object)edge.getTarget())).equals((Object)port)) {
            return edge.getSource();
        }
        throw new IllegalArgumentException("Input edge is not connected to the input port.");
    }
}

