/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.modelexplorer;

import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;

public final class PermissionAuthoritySessionManagerListener
extends SessionManagerListener.Stub {
    private IAuthorityListener authorityListener;

    public void notifyAddSession(Session newSession) {
        PermissionAuthorityRegistry.getDefault().getPermissionAuthority(newSession.getTransactionalEditingDomain().getResourceSet()).addAuthorityListener(this.authorityListener);
    }

    public void notifyRemoveSession(Session removedSession) {
        PermissionAuthorityRegistry.getDefault().getPermissionAuthority(removedSession.getTransactionalEditingDomain().getResourceSet()).removeAuthorityListener(this.authorityListener);
    }

    public void register(IAuthorityListener permissionAuthorityListener) {
        this.authorityListener = permissionAuthorityListener;
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            PermissionAuthorityRegistry.getDefault().getPermissionAuthority(session.getTransactionalEditingDomain().getResourceSet()).addAuthorityListener(this.authorityListener);
        }
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)this);
    }

    public void unregister() {
        SessionManager.INSTANCE.removeSessionsListener((SessionManagerListener)this);
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            PermissionAuthorityRegistry.getDefault().getPermissionAuthority(session.getTransactionalEditingDomain().getResourceSet()).removeAuthorityListener(this.authorityListener);
        }
        this.authorityListener = null;
    }
}

