/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.table.business.internal.refresh.KeyCache;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;

public class DTargetColumnCandidate {
    private final EObject semantic;
    private final ColumnMapping mapping;
    private DTargetColumn element;
    private final int hashCode;
    private RefreshIdsHolder ids;

    public DTargetColumnCandidate(ColumnMapping mapping, EObject semanticElement, RefreshIdsHolder ids) {
        this.mapping = mapping;
        this.semantic = semanticElement;
        this.ids = ids;
        this.hashCode = this.computeHashCode();
    }

    public DTargetColumnCandidate(DTargetColumn tableElement, RefreshIdsHolder ids) {
        this.mapping = tableElement.getOriginMapping();
        this.semantic = tableElement.getTarget();
        this.element = tableElement;
        this.ids = ids;
        this.hashCode = this.computeHashCode();
    }

    public boolean comesFromTableElement() {
        return this.getOriginalElement() != null;
    }

    public DTargetColumn getOriginalElement() {
        return this.element;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int[] parts = new int[]{this.mapping == null ? 0 : this.getMappingID(), this.semantic == null ? 0 : this.getSemanticID()};
        return KeyCache.DEFAULT.getKey(String.valueOf(parts[0]) + "/" + parts[1]);
    }

    public boolean equals(Object obj) {
        Boolean result = null;
        if (this == obj) {
            result = true;
        }
        if (result == null && obj == null) {
            result = false;
        }
        if (result == null && !(obj instanceof DTargetColumnCandidate)) {
            result = false;
        }
        DTargetColumnCandidate other = (DTargetColumnCandidate)obj;
        if (result == null && this.semantic == null) {
            if (other.semantic != null) {
                result = false;
            }
        } else if (result == null && !this.getSemanticID().equals(other.getSemanticID())) {
            result = false;
        }
        if (result == null && this.mapping == null) {
            if (other.mapping != null) {
                result = false;
            }
        } else if (result == null && !this.mapping.equals(other.mapping)) {
            result = false;
        }
        if (result == null) {
            result = true;
        }
        return result;
    }

    private Integer getSemanticID() {
        return this.ids.getOrCreateID(this.semantic);
    }

    private Integer getMappingID() {
        return this.ids.getOrCreateID((EObject)this.mapping);
    }

    public ColumnMapping getMapping() {
        return this.mapping;
    }

    public EObject getSemantic() {
        return this.semantic;
    }
}

