/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.intermediate.optimization;

import org.eclipse.elk.alg.radial.intermediate.optimization.IEvaluation;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class EdgeLengthPositionOptimization
implements IEvaluation {
    @Override
    public double evaluate(ElkNode root) {
        double edgeLength = 0.0;
        for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges((ElkNode)root)) {
            ElkNode target = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getTargets().get(0)));
            double targetX = target.getX() + target.getWidth() / 2.0;
            double targetY = target.getY() + target.getHeight() / 2.0;
            KVector position = (KVector)target.getProperty(CoreOptions.POSITION);
            double rootX = root.getX() + position.x + root.getWidth() / 2.0;
            double rootY = root.getY() + position.y + root.getHeight();
            double vectorX = targetX - rootX;
            double vectorY = targetY - rootY;
            edgeLength += Math.sqrt(vectorX * vectorX + vectorY * vectorY);
        }
        return edgeLength;
    }
}

