/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.table.business.internal.refresh.KeyCache;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.description.ColumnMapping;

public class DCellCandidate {
    private final EObject semantic;
    private final ColumnMapping mapping;
    private final DColumn column;
    private final DLine line;
    private DCell element;
    private int hashcode;
    private RefreshIdsHolder ids;

    public DCellCandidate(ColumnMapping mapping, EObject semanticElement, DLine line, DColumn column, RefreshIdsHolder ids) {
        this.mapping = mapping;
        this.semantic = semanticElement;
        this.line = line;
        this.column = column;
        this.ids = ids;
        this.hashcode = this.computeHashCode();
    }

    public DCellCandidate(DCell tableElement, RefreshIdsHolder ids) {
        this(tableElement.getColumn() != null ? tableElement.getColumn().getOriginMapping() : null, tableElement.getTarget(), tableElement.getLine(), tableElement.getColumn(), ids);
        this.element = tableElement;
    }

    public boolean comesFromTableElement() {
        return this.getOriginalElement() != null;
    }

    public DCell getOriginalElement() {
        return this.element;
    }

    public int hashCode() {
        return this.hashcode;
    }

    private int computeHashCode() {
        int[] parts = new int[]{this.mapping == null ? 0 : this.getMappingID(), this.semantic == null ? 0 : this.getSemanticID(), this.line == null ? 0 : this.getLineID(), this.column == null ? 0 : this.getColumnID()};
        return KeyCache.DEFAULT.getKey(String.valueOf(parts[0]) + "/" + parts[1] + "/" + parts[2] + "/" + parts[3]);
    }

    public boolean equals(Object obj) {
        Boolean result = null;
        if (this == obj) {
            result = true;
        }
        if (result == null && obj == null) {
            result = false;
        }
        if (result == null && !(obj instanceof DCellCandidate)) {
            result = false;
        }
        DCellCandidate other = (DCellCandidate)obj;
        if (result == null && this.semantic == null) {
            if (other.semantic != null) {
                result = false;
            }
        } else if (result == null && !this.getSemanticID().equals(other.getSemanticID())) {
            result = false;
        }
        if (result == null && this.line == null) {
            if (other.line != null) {
                result = false;
            }
        } else if (result == null && !this.getLineID().equals(other.getLineID())) {
            result = false;
        }
        if (result == null && this.column == null) {
            if (other.column != null) {
                result = false;
            }
        } else if (result == null && !this.getColumnID().equals(other.getColumnID())) {
            result = false;
        }
        if (result == null && this.mapping == null) {
            if (other.mapping != null) {
                result = false;
            }
        } else if (result == null && !this.mapping.equals(other.mapping)) {
            result = false;
        }
        if (result == null) {
            result = true;
        }
        return result;
    }

    private Integer getColumnID() {
        return this.ids.getOrCreateID((EObject)this.column);
    }

    private Integer getLineID() {
        return this.ids.getOrCreateID((EObject)this.line);
    }

    private Integer getSemanticID() {
        return this.ids.getOrCreateID(this.semantic);
    }

    private Integer getMappingID() {
        return this.ids.getOrCreateID((EObject)this.mapping);
    }

    public ColumnMapping getMapping() {
        return this.mapping;
    }

    public EObject getSemantic() {
        return this.semantic;
    }

    public DColumn getColumn() {
        return this.column;
    }

    public DLine getLine() {
        return this.line;
    }
}

