/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.sample.component.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tests.sample.component.Component;
import org.eclipse.sirius.tools.api.ui.RefreshHelper;

public class ComponentServices {
    private static Predicate<Notification> considerCollapseStateForAutomaticRefreshPredicate = new Predicate<Notification>(){

        @Override
        public boolean test(Notification notification) {
            Option optionalDDiagram;
            if (notification != null && NotationPackage.eINSTANCE.getDrawerStyle_Collapsed().equals(notification.getFeature()) && notification.getNotifier() instanceof EObject && (optionalDDiagram = new EObjectQuery((EObject)notification.getNotifier()).getParentDiagram()).some()) {
                return "DiagramWithRegionAndEdges".equals(((DDiagram)optionalDDiagram.get()).getDescription().getName());
            }
            return false;
        }
    };

    public static void considerCollapseStateForAutomaticRefresh(EObject context) {
        RefreshHelper.registerImpactingNotification(considerCollapseStateForAutomaticRefreshPredicate);
    }

    public static void doNotConsiderCollapseStateForAutomaticRefresh(EObject context) {
        RefreshHelper.unregisterImpactingNotification(considerCollapseStateForAutomaticRefreshPredicate);
    }

    public Collection<Component> getAllChildren(Component component) {
        ArrayList<Component> allChildren = new ArrayList<Component>();
        this.appendChildren(component, allChildren);
        return allChildren;
    }

    public Collection<Component> getIntersectionColumms(Component line) {
        Component ref2;
        HashSet<Component> validColumns = new HashSet<Component>();
        for (Component ref2 : line.getReferences()) {
            if (ref2.isPayload()) continue;
            validColumns.add(ref2);
        }
        for (Component ref2 : line.getReferences2()) {
            if (ref2.isPayload()) continue;
            validColumns.add(ref2);
        }
        for (Component opposite : line.getOpposites()) {
            if (opposite.isPayload()) continue;
            validColumns.add(opposite);
        }
        ref2 = line.getReference();
        if (ref2 != null && !ref2.isPayload()) {
            validColumns.add(ref2);
        }
        return validColumns;
    }

    public String getIntersectionLabel(Component line, Component column) {
        StringBuilder result = new StringBuilder();
        boolean empty = true;
        if (line.getReferences().contains((Object)column)) {
            result.append("R");
            empty = false;
        }
        if (line.getReferences2().contains((Object)column)) {
            if (empty) {
                result.append("R2");
            } else {
                result.append(", R2");
            }
            empty = false;
        }
        if (line.getOpposites().contains((Object)column)) {
            if (empty) {
                result.append("O");
            } else {
                result.append(", O");
            }
            empty = false;
        }
        if (line.getReference() == column) {
            if (empty) {
                result.append("r");
            } else {
                result.append(", r");
            }
        }
        return result.toString();
    }

    public List<Component> getReference2Hierarchy(Component component) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.addAll((Collection<Component>)component.getReferences2());
        for (Component child : component.getChildren()) {
            components.addAll(this.getReference2Hierarchy(child));
        }
        return components;
    }

    public List<Component> getReference2HierarchyOrigin(Component component) {
        ArrayList<Component> components = new ArrayList<Component>();
        int i = 0;
        while (i < component.getReferences2().size()) {
            components.add(component);
            ++i;
        }
        for (Component child : component.getChildren()) {
            components.addAll(this.getReference2HierarchyOrigin(child));
        }
        return components;
    }

    public Component renameFirstAlias(Component component, String newName) {
        if (component.getAliases().size() > 0) {
            component.getAliases().set(0, (Object)newName);
        }
        return component;
    }

    public boolean isReferenceToDisplay(Component source, DNodeContainer sourceView, DNodeContainer targetView) {
        for (DDiagramElement child : sourceView.getOwnedDiagramElements()) {
            if (!(child instanceof DNodeContainer) || !((DNodeContainer)child).getActualMapping().getName().equals("ComponentRegion")) continue;
            for (DDiagramElement grandchild : ((DNodeContainer)child).getOwnedDiagramElements()) {
                if (!this.isReferenceDisplayedByChild((DNodeContainer)grandchild, targetView)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isReferenceDisplayedByChild(DNodeContainer sourceView, DNodeContainer targetView) {
        if (!this.isIndirectlyCollapsed(sourceView) && !this.isIndirectlyCollapsed(targetView)) {
            for (DDiagramElement child : sourceView.getOwnedDiagramElements()) {
                if (!(child instanceof DNodeContainer) || !((DNodeContainer)child).getActualMapping().getName().equals("ComponentRegion")) continue;
                for (DDiagramElement grandchild : ((DNodeContainer)child).getOwnedDiagramElements()) {
                    if (!this.isReferenceDisplayedByChild((DNodeContainer)grandchild, targetView)) continue;
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isIndirectlyCollapsed(DNodeContainer container) {
        if (this.isContainerCollapsed(container)) {
            return true;
        }
        return container.eContainer() instanceof DNodeContainer && this.isContainerCollapsed((DNodeContainer)container.eContainer());
    }

    protected boolean isContainerCollapsed(DNodeContainer container) {
        Node gmfNode = SiriusGMFHelper.getGmfNode((DDiagramElement)container);
        if (gmfNode != null) {
            for (Object subNode : gmfNode.getChildren()) {
                if (!(subNode instanceof Node)) continue;
                for (Object style : ((Node)subNode).getStyles()) {
                    if (!(style instanceof DrawerStyle)) continue;
                    return ((DrawerStyle)style).isCollapsed();
                }
            }
        }
        return false;
    }

    private void appendChildren(Component component, Collection<Component> allChildren) {
        for (Component child : component.getChildren()) {
            if (child.isPayload()) continue;
            allChildren.add(child);
            this.appendChildren(child, allChildren);
        }
    }
}

