/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.contentassist;

import org.eclipse.sirius.common.tools.api.util.StringUtil;

public class ContentProposal
implements Comparable<ContentProposal> {
    private String proposal;
    private String display;
    private String information;
    private int cursorPosition;

    public ContentProposal(String proposal, String display, String information) {
        this.proposal = proposal;
        this.display = display;
        this.information = information;
        this.cursorPosition = proposal.length();
    }

    public ContentProposal(String proposal, String display, String information, int cursorPosition) {
        this.proposal = proposal;
        this.display = display;
        this.information = information;
        this.cursorPosition = cursorPosition;
    }

    public void addPrefix(String prefix) {
        if (!StringUtil.isEmpty(prefix)) {
            this.proposal = String.valueOf(prefix) + this.proposal;
            this.display = String.valueOf(prefix) + this.display;
            this.cursorPosition += prefix.length();
        }
    }

    public String getProposal() {
        return this.proposal;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getInformation() {
        return this.information;
    }

    @Override
    public int compareTo(ContentProposal other) {
        String nextValue = other.getProposal();
        String currentValue = this.getProposal();
        return currentValue.compareToIgnoreCase(nextValue);
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (this == other) {
            equal = true;
        } else if (other instanceof ContentProposal) {
            String nextValue = ((ContentProposal)other).getProposal();
            String currentValue = this.getProposal();
            equal = currentValue.equalsIgnoreCase(nextValue);
        }
        return equal;
    }

    public int hashCode() {
        return this.getProposal().hashCode();
    }
}

