/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.backend.internal.services.projects;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.server.api.ISiriusServerService;
import org.eclipse.sirius.server.api.SiriusServerPath;
import org.eclipse.sirius.server.api.SiriusServerResponse;
import org.eclipse.sirius.server.backend.internal.SiriusServerMessages;
import org.eclipse.sirius.server.backend.internal.services.projects.SiriusServerNewProjectDto;
import org.eclipse.sirius.server.backend.internal.services.projects.SiriusServerProjectDto;
import org.eclipse.sirius.server.backend.internal.services.projects.SiriusServerProjectsDto;
import org.eclipse.sirius.server.backend.internal.utils.SiriusServerErrorDto;
import org.eclipse.sirius.server.backend.internal.utils.SiriusServerUtils;

@SiriusServerPath(value="/projects")
public class SiriusServerProjectsService
implements ISiriusServerService {
    public SiriusServerResponse doGet(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        return new SiriusServerResponse(200, (Object)this.getModelingProjects());
    }

    private SiriusServerProjectsDto getModelingProjects() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        List<SiriusServerProjectDto> modelingProjects = Arrays.stream(allProjects).filter(ModelingProject::hasModelingProjectNature).filter(IProject::isOpen).map(this::convertToProject).collect(Collectors.toList());
        return new SiriusServerProjectsDto(modelingProjects);
    }

    private SiriusServerProjectDto convertToProject(IProject iProject) {
        String name = iProject.getName();
        String description = SiriusServerUtils.getProjectDescription(iProject);
        return new SiriusServerProjectDto(name, description);
    }

    public SiriusServerResponse doPost(HttpServletRequest request, Map<String, String> variables, String remainingPart) {
        SiriusServerResponse response = null;
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)request.getInputStream(), "UTF-8");
            SiriusServerNewProjectDto newProject = (SiriusServerNewProjectDto)new Gson().fromJson((Reader)reader, SiriusServerNewProjectDto.class);
            String name = newProject.getName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (project.exists()) {
                String message = MessageFormat.format(SiriusServerMessages.SiriusServerProjectsService_projectAlreadyExists, name);
                response = new SiriusServerResponse(400, (Object)new SiriusServerErrorDto(message));
            } else {
                IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(name);
                projectDescription.setNatureIds(new String[]{"org.eclipse.sirius.nature.modelingproject"});
                project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
                URI representationsURI = URI.createPlatformResourceURI((String)project.getFullPath().append("representations.aird").toString(), (boolean)true);
                DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(representationsURI, (IProgressMonitor)new NullProgressMonitor());
                sessionCreationOperation.execute();
                String description = SiriusServerUtils.getProjectDescription(project);
                response = new SiriusServerResponse(201, (Object)new SiriusServerProjectDto(name, description));
            }
        }
        catch (IOException | CoreException throwable) {
            response = new SiriusServerResponse(500);
        }
        return response;
    }
}

