/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema.query.user;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.Optional;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class UserViewpointField {
    private static final String VIEWPOINT_FIELD = "viewpoint";
    private static final String VIEWPOINT_IDENTIFIER_ARG = "identifier";

    private UserViewpointField() {
    }

    public static GraphQLFieldDefinition build() {
        return GraphQLFieldDefinition.newFieldDefinition().name(VIEWPOINT_FIELD).type((GraphQLOutputType)new GraphQLTypeReference("Viewpoint")).argument(UserViewpointField.getViewpointFieldIdentifierArg()).dataFetcher(UserViewpointField.getViewpointDataFetcher()).build();
    }

    private static GraphQLArgument getViewpointFieldIdentifierArg() {
        return GraphQLArgument.newArgument().name(VIEWPOINT_IDENTIFIER_ARG).type((GraphQLInputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).build();
    }

    private static DataFetcher<Viewpoint> getViewpointDataFetcher() {
        return environment -> {
            Optional<String> optionalViewpointIdentifier = Optional.of(environment.getArgument(VIEWPOINT_IDENTIFIER_ARG)).filter(String.class::isInstance).map(String.class::cast);
            Optional optionalViewpoint = optionalViewpointIdentifier.flatMap(viewpointIdentifier -> ViewpointRegistry.getInstance().getViewpoints().stream().filter(viewpoint -> viewpointIdentifier.equals(viewpoint.getName())).findFirst());
            return optionalViewpoint.orElse(null);
        };
    }
}

