/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal.dialog;

import java.util.ArrayList;
import java.util.Optional;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.eef.EEFViewDescription;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.EEFView;
import org.eclipse.eef.core.api.EEFViewFactory;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.IEEFDomainClassTester;
import org.eclipse.eef.core.api.InputDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.common.interpreter.api.VariableManagerFactory;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.properties.DialogModelOperation;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.core.api.DialogModelOperationPreprocessor;
import org.eclipse.sirius.properties.core.api.OverridesProvider;
import org.eclipse.sirius.properties.core.api.SiriusDomainClassTester;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.sirius.properties.core.api.SiriusInterpreter;
import org.eclipse.sirius.properties.core.api.ViewDescriptionConverter;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.ui.properties.internal.EditingContextAdapterWrapper;
import org.eclipse.sirius.ui.properties.internal.Messages;
import org.eclipse.sirius.ui.properties.internal.SiriusUIPropertiesPlugin;
import org.eclipse.sirius.ui.properties.internal.dialog.PropertiesFormDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DialogTask
extends AbstractOperationTask {
    private Session session;
    private DialogModelOperation dialogModelOperation;

    public DialogTask(CommandContext context, ModelAccessor modelAccessor, IInterpreter interpreter, Session session, DialogModelOperation dialogModelOperation) {
        super(context, modelAccessor, interpreter);
        this.session = session;
        this.dialogModelOperation = dialogModelOperation;
    }

    public String getLabel() {
        return Messages.DialogTask_label;
    }

    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
        SiriusInputDescriptor input = new SiriusInputDescriptor((Object)this.context.getCurrentTarget());
        IVariableManager variableManager = new VariableManagerFactory().createVariableManager();
        variableManager.put("self", (Object)input.getSemanticElement());
        variableManager.put("input", (Object)input);
        SiriusInterpreter siriusInterpreter = new SiriusInterpreter(this.session);
        DialogModelOperationPreprocessor preprocessor = new DialogModelOperationPreprocessor(this.dialogModelOperation, (org.eclipse.sirius.common.interpreter.api.IInterpreter)siriusInterpreter, variableManager, new OverridesProvider(this.session));
        Optional optionalDialogModelOperation = preprocessor.convert();
        optionalDialogModelOperation.ifPresent(convertedDialogModelOperation -> {
            PageDescription pageDescription = convertedDialogModelOperation.getPage();
            ArrayList<PageDescription> pageDescriptions = new ArrayList<PageDescription>();
            pageDescriptions.add(pageDescription);
            ViewDescriptionConverter viewDescriptionConverter = new ViewDescriptionConverter(pageDescriptions);
            EEFViewDescription eefViewDescription = viewDescriptionConverter.convert(input);
            EditingContextAdapter editingContextAdapter = SiriusUIPropertiesPlugin.getPlugin().getEditingContextAdapter(this.session);
            EditingContextAdapterWrapper wrapper = new EditingContextAdapterWrapper(editingContextAdapter);
            EEFViewFactory eefViewFactory = new EEFViewFactory();
            EEFView eefView = eefViewFactory.createEEFView(eefViewDescription, variableManager, (org.eclipse.sirius.common.interpreter.api.IInterpreter)siriusInterpreter, (EditingContextAdapter)wrapper, (IEEFDomainClassTester)new SiriusDomainClassTester(this.session), (InputDescriptor)input);
            if (eefView.getPages().size() == 1) {
                boolean isInUiThread;
                EEFPage eefPage = (EEFPage)eefView.getPages().get(0);
                Runnable runnable = () -> {
                    Shell shell = Display.getCurrent().getActiveShell();
                    PropertiesFormDialog formDialog = new PropertiesFormDialog(shell, this.extPackage, this.context, this.session, (org.eclipse.sirius.common.interpreter.api.IInterpreter)siriusInterpreter, variableManager, (DialogModelOperation)convertedDialogModelOperation, eefPage);
                    formDialog.create();
                    formDialog.getShell().setMinimumSize(600, 200);
                    int returnCode = formDialog.open();
                    if (1 == returnCode) {
                        throw new OperationCanceledException();
                    }
                };
                boolean bl = isInUiThread = Display.getCurrent() != null && Display.getCurrent().getActiveShell() != null;
                if (isInUiThread) {
                    runnable.run();
                } else {
                    Display.getDefault().syncExec(runnable);
                }
            }
        });
    }
}

