/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.diagram.internal.converter;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.BorderedStyle;
import org.eclipse.sirius.services.diagram.api.entities.AbstractSiriusDiagramElement;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramLabel;
import org.eclipse.sirius.services.diagram.api.entities.SiriusDiagramRGBColor;
import org.eclipse.sirius.services.diagram.internal.SiriusDiagramPlugin;
import org.eclipse.sirius.services.diagram.internal.converter.ISiriusDiagramElementConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramColorConverter;
import org.eclipse.sirius.services.diagram.internal.converter.SiriusDiagramElementSwitch;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;

public abstract class AbstractSiriusDiagramNodeConverter
implements ISiriusDiagramElementConverter {
    protected abstract AbstractDNode getDNode();

    protected String getIdentifier() {
        return EcoreUtil.getURI((EObject)this.getDNode()).toString();
    }

    protected String getSemanticElementIdentifier() {
        return EcoreUtil.getURI((EObject)this.getDNode().getTarget()).toString();
    }

    protected SiriusDiagramLabel getLabel(String identifier, BasicLabelStyle style) {
        SiriusDiagramRGBColor labelColor = SiriusDiagramColorConverter.convert(style.getLabelColor());
        return new SiriusDiagramLabel(String.valueOf(identifier) + "__label", this.getDNode().getName(), labelColor);
    }

    protected SiriusDiagramRGBColor getBorderColor(BorderedStyle style) {
        return SiriusDiagramColorConverter.convert(style.getBorderColor());
    }

    protected int getBorderSize(BorderedStyle style) {
        return Optional.ofNullable(style.getBorderSize()).orElse(1);
    }

    protected List<AbstractSiriusDiagramElement> getPorts() {
        return this.getDNode().getOwnedBorderedNodes().stream().map(new SiriusDiagramElementSwitch()::doSwitch).map(ISiriusDiagramElementConverter::convert).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    protected String getImagePath() {
        return SiriusDiagramPlugin.getPlugin().getImagePathProvider().flatMap(provider -> provider.getLabelProviderImagePath(this.getDNode().getTarget())).orElse(null);
    }
}

