/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.alignmentgroup.internal.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.group.model.VGroup;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.reporting.StatusReport;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractAdditionalSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class EmbeddedGroupSWTRenderer
extends AbstractSWTRenderer<VGroup> {
    private final EMFFormsRendererFactory rendererFactory;
    private final EMFDataBindingContext dbc;
    private SWTGridDescription currentGridDescription;

    @Inject
    public EmbeddedGroupSWTRenderer(VGroup vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsRendererFactory rendererFactory) {
        super((VElement)vElement, viewContext, reportService);
        this.rendererFactory = rendererFactory;
        this.dbc = new EMFDataBindingContext();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        this.currentGridDescription = new SWTGridDescription();
        ArrayList<SWTGridCell> grid = new ArrayList<SWTGridCell>();
        this.currentGridDescription.setRows(((VGroup)this.getVElement()).getChildren().size() + 1);
        this.currentGridDescription.setGrid(grid);
        int row = 1;
        LinkedHashMap gridCellsPerRow = new LinkedHashMap();
        for (VContainedElement containedElement : ((VGroup)this.getVElement()).getChildren()) {
            AbstractSWTRenderer renderer;
            gridCellsPerRow.put(row, new ArrayList());
            try {
                renderer = this.rendererFactory.getRendererInstance((VElement)containedElement, this.getViewModelContext());
            }
            catch (EMFFormsNoRendererException ex) {
                this.getReportService().report((AbstractReport)new StatusReport(new Status(1, "org.eclipse.emf.ecp.view.group.swt.embedded", String.format("No Renderer for %s found.", containedElement.eClass().getName()), (Throwable)ex)));
                continue;
            }
            Collection additionalRenderers = this.rendererFactory.getAdditionalRendererInstances((VElement)containedElement, this.getViewModelContext());
            SWTGridDescription rendererGridDescription = renderer.getGridDescription(GridDescriptionFactory.INSTANCE.createEmptyGridDescription());
            for (AbstractAdditionalSWTRenderer additionalRenderer : additionalRenderers) {
                rendererGridDescription = additionalRenderer.getGridDescription(rendererGridDescription);
            }
            if (this.currentGridDescription.getColumns() < rendererGridDescription.getColumns()) {
                this.currentGridDescription.setColumns(rendererGridDescription.getColumns());
            }
            for (SWTGridCell rendererGridCell : rendererGridDescription.getGrid()) {
                SWTGridCell gc = new SWTGridCell(row, rendererGridCell.getColumn(), (AbstractSWTRenderer)rendererGridCell.getRenderer());
                gc.setHorizontalAlignment(rendererGridCell.getHorizontalAlignment());
                gc.setHorizontalFill(rendererGridCell.isHorizontalFill());
                gc.setHorizontalGrab(rendererGridCell.isHorizontalGrab());
                gc.setHorizontalSpan(rendererGridCell.getHorizontalSpan());
                gc.setVerticalAlignment(rendererGridCell.getVerticalAlignment());
                gc.setVerticalFill(rendererGridCell.isVerticalFill());
                gc.setVerticalGrab(rendererGridCell.isVerticalGrab());
                gc.setPreferredSize(rendererGridCell.getPreferredSize());
                this.currentGridDescription.getGrid().add(gc);
                ((List)gridCellsPerRow.get(row)).add(gc);
            }
            ++row;
        }
        int i = 0;
        while (i < this.currentGridDescription.getColumns()) {
            SWTGridCell gridCell = new SWTGridCell(0, i, (AbstractSWTRenderer)this);
            gridCell.setVerticalGrab(false);
            gridCell.setVerticalFill(false);
            gridCell.setHorizontalFill(false);
            gridCell.setHorizontalGrab(false);
            grid.add(i, gridCell);
            ++i;
        }
        for (Integer gdRow : gridCellsPerRow.keySet()) {
            List rowGridCells = (List)gridCellsPerRow.get(gdRow);
            if (this.currentGridDescription.getColumns() <= rowGridCells.size()) continue;
            ((SWTGridCell)rowGridCells.get(rowGridCells.size() - 1)).setHorizontalSpan(this.currentGridDescription.getColumns() - rowGridCells.size() + 1);
        }
        return this.currentGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        if (((AbstractSWTRenderer)cell.getRenderer()).equals((Object)this)) {
            Control heading = this.createHeadingControl(parent);
            switch (((VGroup)this.getVElement()).getLabelAlignment()) {
                case LABEL_ALIGNED: {
                    if (cell.getColumn() != 0) break;
                    this.bindValue(heading);
                    heading.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_view_group_title");
                    break;
                }
                case INPUT_ALIGNED: {
                    if (cell.getColumn() + 1 != this.currentGridDescription.getColumns()) break;
                    heading.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_view_group_title");
                    break;
                }
            }
            return heading;
        }
        return ((AbstractSWTRenderer)cell.getRenderer()).render(cell, parent);
    }

    protected Control createHeadingControl(Composite parent) {
        Label heading = new Label(parent, 0);
        heading.setBackground(parent.getBackground());
        return heading;
    }

    private void bindValue(Control target) {
        ISWTObservableValue targetValue = WidgetProperties.text().observe((Widget)target);
        IObservableValue modelValue = EMFEditObservables.observeValue((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getVElement()), (EObject)this.getVElement(), (EStructuralFeature)VViewPackage.eINSTANCE.getElement_Label());
        this.dbc.bindValue((IObservableValue)targetValue, modelValue);
    }

    protected void dispose() {
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        super.dispose();
    }
}

