/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Signale.Befestigung_Art_TypeClass;
import org.eclipse.set.model.planpro.Signale.ENUMBefestigungArt;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Signale.Signal_Befestigung;
import org.eclipse.set.model.planpro.Signale.Signal_Befestigung_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Rahmen;
import org.eclipse.set.model.planpro.Signale.Signal_Signalbegriff;
import org.eclipse.set.model.planpro.Verweise.ID_Signal_Befestigung_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Signal_TypeClass;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.SignalBefestigungExtensions;
import org.eclipse.set.ppmodel.extensions.SignalbegriffExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalRahmenExtensions
extends BasisObjektExtensions {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignalRahmenExtensions.class);

    public static List<Signal_Signalbegriff> getSignalbegriffe(Signal_Rahmen signalRahmen) {
        Functions.Function1 _function = b -> {
            Signal_Rahmen _signalRahmen = SignalbegriffExtensions.signalRahmen(b);
            return Objects.equals(_signalRahmen, signalRahmen);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)signalRahmen).getSignalSignalbegriff(), (Functions.Function1)_function));
    }

    public static Signal getSignal(Signal_Rahmen signalRahmen) {
        ID_Signal_TypeClass _iDSignal = signalRahmen.getIDSignal();
        Signal _value = null;
        if (_iDSignal != null) {
            _value = _iDSignal.getValue();
        }
        return _value;
    }

    public static Signal getSignalNachordnung(Signal_Rahmen signalRahmen) {
        ID_Signal_TypeClass _iDSignalNachordnung = signalRahmen.getIDSignalNachordnung();
        Signal _value = null;
        if (_iDSignalNachordnung != null) {
            _value = _iDSignalNachordnung.getValue();
        }
        return _value;
    }

    public static Signal_Befestigung getSignalBefestigung(Signal_Rahmen signalRahmen) {
        ID_Signal_Befestigung_TypeClass _iDSignalBefestigung = null;
        if (signalRahmen != null) {
            _iDSignalBefestigung = signalRahmen.getIDSignalBefestigung();
        }
        Signal_Befestigung _value = null;
        if (_iDSignalBefestigung != null) {
            _value = _iDSignalBefestigung.getValue();
        }
        return _value;
    }

    public static Signal_Befestigung getFundament(Signal_Rahmen signalRahmen) {
        LOGGER.debug("getFundament started...");
        Iterator<Signal_Befestigung> _signalBefestigungIterator = null;
        if (signalRahmen != null) {
            _signalBefestigungIterator = SignalRahmenExtensions.getSignalBefestigungIterator(signalRahmen);
        }
        Signal_Befestigung _findFirst = null;
        if (_signalBefestigungIterator != null) {
            Functions.Function1 _function = it -> {
                Signal_Befestigung_Allg_AttributeGroup _signalBefestigungAllg = it.getSignalBefestigungAllg();
                Befestigung_Art_TypeClass _befestigungArt = null;
                if (_signalBefestigungAllg != null) {
                    _befestigungArt = _signalBefestigungAllg.getBefestigungArt();
                }
                ENUMBefestigungArt _wert = null;
                if (_befestigungArt != null) {
                    _wert = _befestigungArt.getWert();
                }
                return Objects.equals(_wert, ENUMBefestigungArt.ENUM_BEFESTIGUNG_ART_FUNDAMENT);
            };
            _findFirst = (Signal_Befestigung)IteratorExtensions.findFirst(_signalBefestigungIterator, (Functions.Function1)_function);
        }
        Signal_Befestigung befestigung = _findFirst;
        LOGGER.debug("getFundament finished.");
        return befestigung;
    }

    public static Iterator<Signal_Befestigung> getSignalBefestigungIterator(Signal_Rahmen signalRahmen) {
        return new SignalBefestigungIterator(signalRahmen);
    }

    private static class SignalBefestigungIterator
    implements Iterator<Signal_Befestigung> {
        private Basis_Objekt lastBasisObjekt;
        private Basis_Objekt nextBasisObjekt;
        private Set<Basis_Objekt> visited = Sets.newHashSet();

        public SignalBefestigungIterator(Signal_Rahmen rahmen) {
            this.lastBasisObjekt = rahmen;
            this.visit((Basis_Objekt)rahmen);
        }

        public void visit(Basis_Objekt object) {
            boolean _contains = this.visited.contains(object);
            if (_contains) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)object);
                _builder.append(" already visited");
                throw new IllegalArgumentException(_builder.toString());
            }
            this.visited.add(object);
        }

        @Override
        public boolean hasNext() {
            this.nextBasisObjekt = SignalBefestigungIterator.findNextBefestigung(this.lastBasisObjekt);
            return this.nextBasisObjekt != null && this.nextBasisObjekt != this.lastBasisObjekt;
        }

        private static Basis_Objekt _findNextBefestigung(Basis_Objekt objekt) {
            String _simpleName = objekt.getClass().getSimpleName();
            throw new IllegalArgumentException(_simpleName);
        }

        private static Basis_Objekt _findNextBefestigung(Signal_Rahmen rahmen) {
            boolean _tripleEquals;
            ID_Signal_Befestigung_TypeClass _iDSignalBefestigung = rahmen.getIDSignalBefestigung();
            boolean bl = _tripleEquals = _iDSignalBefestigung == null;
            if (_tripleEquals) {
                return null;
            }
            return SignalRahmenExtensions.getSignalBefestigung(rahmen);
        }

        private static Basis_Objekt _findNextBefestigung(Signal_Befestigung befestigung) {
            boolean _tripleEquals;
            ID_Signal_Befestigung_TypeClass _iDSignalBefestigung = befestigung.getIDSignalBefestigung();
            boolean bl = _tripleEquals = _iDSignalBefestigung == null;
            if (_tripleEquals) {
                return null;
            }
            return SignalBefestigungExtensions.getSignalBefestigung(befestigung);
        }

        @Override
        public Signal_Befestigung next() {
            boolean _hasNext = this.hasNext();
            if (_hasNext) {
                this.lastBasisObjekt = this.nextBasisObjekt;
                this.visit(this.nextBasisObjekt);
                return (Signal_Befestigung)this.lastBasisObjekt;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @XbaseGenerated
        private static Basis_Objekt findNextBefestigung(Basis_Objekt befestigung) {
            if (befestigung instanceof Signal_Befestigung) {
                return SignalBefestigungIterator._findNextBefestigung((Signal_Befestigung)befestigung);
            }
            if (befestigung instanceof Signal_Rahmen) {
                return SignalBefestigungIterator._findNextBefestigung((Signal_Rahmen)befestigung);
            }
            if (befestigung != null) {
                return SignalBefestigungIterator._findNextBefestigung(befestigung);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(befestigung).toString());
        }
    }
}

