/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.basis.graph.DirectedEdgePoint;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.Bahnuebergang.BUE_Anlage;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.Bezeichnung_Tabelle_TypeClass;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.model.planpro.Fahrstrasse.Bezeichnung_Fstr_DWeg_TypeClass;
import org.eclipse.set.model.planpro.Fahrstrasse.ENUMFstrMittelArt;
import org.eclipse.set.model.planpro.Fahrstrasse.ENUMFstrRangierArt;
import org.eclipse.set.model.planpro.Fahrstrasse.ENUMFstrZugArt;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_DWeg;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_DWeg_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_DWeg_Spezifisch_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Mittel_Art_TypeClass;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Mittel_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Nichthaltfall;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Rangier_Art_TypeClass;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Rangier_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Rangier_Fla_Zuordnung;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Reihenfolge_TypeClass;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Signalisierung;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_Art_TypeClass;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_DWeg_AttributeGroup;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_Rangier_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.planpro.Gleis.ENUMGleisart;
import org.eclipse.set.model.planpro.Gleis.Geschwindigkeit_TypeClass;
import org.eclipse.set.model.planpro.Gleis.Gleis_Abschnitt;
import org.eclipse.set.model.planpro.Ortung.FMA_Anlage;
import org.eclipse.set.model.planpro.Signalbegriffe_Ril_301.Kl;
import org.eclipse.set.model.planpro.Signale.ENUMSignalArt;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Signale.Signal_Art_TypeClass;
import org.eclipse.set.model.planpro.Signale.Signal_Real_Aktiv_Schirm_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Real_AttributeGroup;
import org.eclipse.set.model.planpro.Signale.Signal_Signalbegriff;
import org.eclipse.set.model.planpro.Verweise.ID_Fstr_DWeg_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Fstr_Fahrweg_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Fstr_Zug_Rangier_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Signal_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Ziel_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Geschwindigkeit_L_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Geschwindigkeit_R_TypeClass;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Kreuzung_AttributeGroup;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.Zungenpaar_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BueAnlageExtensions;
import org.eclipse.set.ppmodel.extensions.BueEinschaltungZuordnungExtension;
import org.eclipse.set.ppmodel.extensions.BueGleisbezogenerGefahrraumExtensions;
import org.eclipse.set.ppmodel.extensions.ENUMWirkrichtungExtensions;
import org.eclipse.set.ppmodel.extensions.FahrwegExtensions;
import org.eclipse.set.ppmodel.extensions.FstrSignalisierungExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.SignalRahmenExtensions;
import org.eclipse.set.ppmodel.extensions.SignalbegriffExtensions;
import org.eclipse.set.ppmodel.extensions.StellBereichExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspKomponenteExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CrossingRoute;
import org.eclipse.set.ppmodel.extensions.utils.GestellteWeiche;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.set.ppmodel.extensions.utils.WeichenSchenkel;
import org.eclipse.set.utils.math.BigIntegerExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class FstrZugRangierExtensions
extends BasisObjektExtensions {
    public static List<Fstr_Signalisierung> fstrSignalisierung(Fstr_Zug_Rangier fstr) {
        LinkedList<Fstr_Signalisierung> result = new LinkedList<Fstr_Signalisierung>();
        Iterable signalisierungen = BasisAttributExtensions.getContainer((EObject)fstr).getFstrSignalisierung();
        for (Fstr_Signalisierung signalisierung : signalisierungen) {
            String _wert_1;
            boolean _equals;
            ID_Fstr_Zug_Rangier_TypeClass _iDFstrZugRangier = signalisierung.getIDFstrZugRangier();
            Fstr_Zug_Rangier _value = null;
            if (_iDFstrZugRangier != null) {
                _value = _iDFstrZugRangier.getValue();
            }
            Identitaet_TypeClass _identitaet = null;
            if (_value != null) {
                _identitaet = _value.getIdentitaet();
            }
            String _wert = null;
            if (_identitaet != null) {
                _wert = _identitaet.getWert();
            }
            if (!(_equals = Objects.equals(_wert, _wert_1 = fstr.getIdentitaet().getWert()))) continue;
            result.add(signalisierung);
        }
        return result;
    }

    public static Fstr_DWeg getFstrDWeg(Fstr_Zug_Rangier zugRangier) {
        Fstr_Zug_AttributeGroup _fstrZug = null;
        if (zugRangier != null) {
            _fstrZug = zugRangier.getFstrZug();
        }
        Fstr_Zug_DWeg_AttributeGroup _fstrZugDWeg = null;
        if (_fstrZug != null) {
            _fstrZugDWeg = _fstrZug.getFstrZugDWeg();
        }
        ID_Fstr_DWeg_TypeClass _iDFstrDWeg = null;
        if (_fstrZugDWeg != null) {
            _iDFstrDWeg = _fstrZugDWeg.getIDFstrDWeg();
        }
        Fstr_DWeg _value = null;
        if (_iDFstrDWeg != null) {
            _value = _iDFstrDWeg.getValue();
        }
        return _value;
    }

    public static Fstr_Fahrweg getFstrFahrweg(Fstr_Zug_Rangier zugRangier) {
        ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg = zugRangier.getIDFstrFahrweg();
        Fstr_Fahrweg _value = null;
        if (_iDFstrFahrweg != null) {
            _value = _iDFstrFahrweg.getValue();
        }
        return _value;
    }

    public static Iterable<Fstr_Rangier_Fla_Zuordnung> getFstrRangierFlaZuordnung(Fstr_Zug_Rangier fstrZugRangier) {
        Functions.Function1 _function = it -> {
            ID_Fstr_Zug_Rangier_TypeClass _iDFstrRangier = it.getIDFstrRangier();
            Fstr_Zug_Rangier _value = null;
            if (_iDFstrRangier != null) {
                _value = _iDFstrRangier.getValue();
            }
            return _value == fstrZugRangier;
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fstrZugRangier).getFstrRangierFlaZuordnung(), (Functions.Function1)_function);
    }

    public static List<Fstr_Nichthaltfall> getFstrNichthaltfall(Fstr_Zug_Rangier fstrZugRangier) {
        Functions.Function1 _function = it -> {
            ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg = it.getIDFstrFahrweg();
            String _wert = null;
            if (_iDFstrFahrweg != null) {
                _wert = _iDFstrFahrweg.getWert();
            }
            ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg_1 = fstrZugRangier.getIDFstrFahrweg();
            String _wert_1 = null;
            if (_iDFstrFahrweg_1 != null) {
                _wert_1 = _iDFstrFahrweg_1.getWert();
            }
            return Objects.equals(_wert, _wert_1);
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toList((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fstrZugRangier).getFstrNichthaltfall(), (Functions.Function1)_function));
    }

    public static List<GestellteWeiche> getEntscheidungsweichen(Fstr_Zug_Rangier fstrZugRangier, List<ENUMGleisart> notUsable) {
        Fstr_Fahrweg fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
        DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> path = FahrwegExtensions.getPath(fstrFahrweg);
        List fwSinglePoints = IteratorExtensions.toList((Iterator)path.getPointIterator());
        Functions.Function1 _function = it -> PunktObjektTopKanteExtensions.getPunktObjekt(it);
        Functions.Function1 _function_1 = it -> WKrGspKomponenteExtensions.hasZungenpaar(it);
        List wKomponenten = IterableExtensions.toUniqueList(org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)fwSinglePoints, (Functions.Function1)_function), W_Kr_Gsp_Komponente.class), (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = it -> FahrwegExtensions.getEntscheidungsweiche(fstrFahrweg, it, notUsable);
        List<GestellteWeiche> weichen = IterableExtensions.toUniqueList(org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)ListExtensions.map(wKomponenten, (Functions.Function1)_function_2)));
        return weichen;
    }

    public static int geschwindigkeit(Fstr_Zug_Rangier fstrZugRangier) {
        boolean _not;
        int vmin = -1;
        Fstr_Fahrweg fw = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
        Functions.Function1 _function = it -> PunktObjektTopKanteExtensions.getPunktObjekt(it);
        Functions.Function1 _function_1 = it -> FstrZugRangierExtensions.getVmax(it, fw);
        Functions.Function1 _function_2 = it -> it >= 0;
        List vmax = IteratorExtensions.toList((Iterator)IteratorExtensions.filter((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.map((Iterator)FahrwegExtensions.getPath(fw).getPointIterator(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1 _function_3 = it -> FstrZugRangierExtensions.getVmax(it, fw);
        Functions.Function1 _function_4 = it -> it >= 0;
        Iterables.addAll((Collection)vmax, (Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map(FahrwegExtensions.getGleisabschnitte(fw), (Functions.Function1)_function_3), (Functions.Function1)_function_4));
        boolean _isEmpty = vmax.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            vmin = (Integer)org.eclipse.xtext.xbase.lib.IterableExtensions.min((Iterable)vmax);
        }
        if (vmin < 0) {
            return Integer.MAX_VALUE;
        }
        return vmin;
    }

    public static boolean isImFahrweg(Fstr_Zug_Rangier fstrZugRangier, Signal_Signalbegriff signalbegriff) {
        return FahrwegExtensions.getSignalbegriffeImFahrweg(FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier)).contains(signalbegriff);
    }

    public static Set<BUE_Anlage> getBUesImGefahrraum(Fstr_Zug_Rangier fstrZugRangier) {
        Functions.Function1 _function = it -> {
            Functions.Function1 _function_1 = it_1 -> BueGleisbezogenerGefahrraumExtensions.getEinschaltungZuordnungen(it_1);
            Functions.Function1 _function_2 = it_1 -> BueEinschaltungZuordnungExtension.getEinschaltung(it_1);
            Functions.Function1 _function_3 = it_1 -> {
                Functions.Function1 _function_4 = it_2 -> it_2.getValue().getIdentitaet().getWert();
                return ListExtensions.map((List)fstrZugRangier.getFstrZug().getIDBUEEinschaltung(), (Functions.Function1)_function_4).contains(it_1.getIdentitaet().getWert());
            };
            return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.map((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map(BueAnlageExtensions.getGleisbezogeneGefahrraeume(it), (Functions.Function1)_function_1))), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)fstrZugRangier).getBUEAnlage(), (Functions.Function1)_function));
    }

    public static List<Signal> getVorsignalisierung(Fstr_Zug_Rangier fstrZugRangier) {
        Functions.Function1 _function = it -> FstrZugRangierExtensions.isVorsignalisierung(fstrZugRangier, (DirectedEdgePoint<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>)it);
        Functions.Function1 _function_1 = it -> (Punkt_Objekt_TOP_Kante_AttributeGroup)it.getPoint();
        Functions.Function1 _function_2 = it -> PunktObjektTopKanteExtensions.getPunktObjekt(it);
        return IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.map((Iterator)IteratorExtensions.filter((Iterator)FahrwegExtensions.getPath(FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier)).getEdgePointIterator(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), Signal.class));
    }

    public static boolean isKennlichtSignalisierung(Fstr_Zug_Rangier fstrZugRangier, Signal signal) {
        Functions.Function1 _function = it -> SignalbegriffExtensions.hasSignalbegriffID(FstrSignalisierungExtensions.getSignalSignalbegriff(it), Kl.class);
        Functions.Function1 _function_1 = it -> {
            String _wert = SignalRahmenExtensions.getSignal(SignalbegriffExtensions.signalRahmen(FstrSignalisierungExtensions.getSignalSignalbegriff(it))).getIdentitaet().getWert();
            String _wert_1 = signal.getIdentitaet().getWert();
            return Objects.equals(_wert, _wert_1);
        };
        return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filter(FstrZugRangierExtensions.fstrSignalisierung(fstrZugRangier), (Functions.Function1)_function), (Functions.Function1)_function_1);
    }

    public static Set<FMA_Anlage> getFmaAnlageRangierFrei(Fstr_Zug_Rangier fstrZugRangier) {
        Fstr_Rangier_AttributeGroup _fstrRangier = null;
        if (fstrZugRangier != null) {
            _fstrRangier = fstrZugRangier.getFstrRangier();
        }
        EList _iDFMAAnlageRangierFrei = null;
        if (_fstrRangier != null) {
            _iDFMAAnlageRangierFrei = _fstrRangier.getIDFMAAnlageRangierFrei();
        }
        List _map = null;
        if (_iDFMAAnlageRangierFrei != null) {
            Functions.Function1 _function = it -> it.getValue();
            _map = ListExtensions.map((List)_iDFMAAnlageRangierFrei, (Functions.Function1)_function);
        }
        Iterable _filterNull = null;
        if (_map != null) {
            _filterNull = org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull((Iterable)_map);
        }
        Set _set = null;
        if (_filterNull != null) {
            _set = org.eclipse.xtext.xbase.lib.IterableExtensions.toSet((Iterable)_filterNull);
        }
        return _set;
    }

    public static <T> String getFstrZugRangierBezeichnung(Fstr_Zug_Rangier fstrZugRangier) {
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals;
        boolean _or = false;
        Fstr_Zug_AttributeGroup _fstrZug = null;
        if (fstrZugRangier != null) {
            _fstrZug = fstrZugRangier.getFstrZug();
        }
        boolean bl = _tripleNotEquals = _fstrZug != null;
        if (_tripleNotEquals) {
            _or = true;
        } else {
            boolean _tripleNotEquals_1;
            Fstr_Mittel_AttributeGroup _fstrMittel = null;
            if (fstrZugRangier != null) {
                _fstrMittel = fstrZugRangier.getFstrMittel();
            }
            _or = _tripleNotEquals_1 = _fstrMittel != null;
        }
        if (_or) {
            Functions.Function1 _function = it -> FstrZugRangierExtensions.isZ(it);
            return FstrZugRangierExtensions.getZugFstrBezeichnung(fstrZugRangier, (Functions.Function1<? super Fstr_Zug_Rangier, ? extends Boolean>)_function);
        }
        Fstr_Rangier_AttributeGroup _fstrRangier = null;
        if (fstrZugRangier != null) {
            _fstrRangier = fstrZugRangier.getFstrRangier();
        }
        boolean bl2 = _tripleNotEquals_2 = _fstrRangier != null;
        if (_tripleNotEquals_2) {
            Functions.Function1 _function_1 = it -> FstrZugRangierExtensions.isR(it);
            return FstrZugRangierExtensions.getRangierFstrBezeichnung(fstrZugRangier, (Functions.Function1<? super Fstr_Zug_Rangier, ? extends Boolean>)_function_1);
        }
        return null;
    }

    public static String getRangierFstrBezeichnung(Fstr_Zug_Rangier fstrZugRangier, Functions.Function1<? super Fstr_Zug_Rangier, ? extends Boolean> condition) {
        int fstrReihenfolge;
        boolean _not;
        Boolean _apply = (Boolean)condition.apply((Object)fstrZugRangier);
        boolean bl = _not = _apply == false;
        if (_not) {
            return null;
        }
        String _elvis = null;
        Fstr_Fahrweg _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
        Signal _start = null;
        if (_fstrFahrweg != null) {
            _start = FahrwegExtensions.getStart(_fstrFahrweg);
        }
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (_start != null) {
            _bezeichnung = _start.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
        if (_bezeichnung != null) {
            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
        }
        String _wert = null;
        if (_bezeichnungTabelle != null) {
            _wert = _bezeichnungTabelle.getWert();
        }
        _elvis = _wert != null ? _wert : "";
        String fstrFahrwegStartSignalBezeichnung = _elvis;
        String _elvis_1 = null;
        Fstr_Fahrweg _fstrFahrweg_1 = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
        Signal _zielSignal = null;
        if (_fstrFahrweg_1 != null) {
            _zielSignal = FahrwegExtensions.getZielSignal(_fstrFahrweg_1);
        }
        Bezeichnung_Element_AttributeGroup _bezeichnung_1 = null;
        if (_zielSignal != null) {
            _bezeichnung_1 = _zielSignal.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle_1 = null;
        if (_bezeichnung_1 != null) {
            _bezeichnungTabelle_1 = _bezeichnung_1.getBezeichnungTabelle();
        }
        String _wert_1 = null;
        if (_bezeichnungTabelle_1 != null) {
            _wert_1 = _bezeichnungTabelle_1.getWert();
        }
        _elvis_1 = _wert_1 != null ? _wert_1 : "";
        String fstrFahrwegZielSignalBezeichnung = _elvis_1;
        Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg = null;
        if (fstrZugRangier != null) {
            _fstrZugRangierAllg = fstrZugRangier.getFstrZugRangierAllg();
        }
        Fstr_Reihenfolge_TypeClass _fstrReihenfolge = null;
        if (_fstrZugRangierAllg != null) {
            _fstrReihenfolge = _fstrZugRangierAllg.getFstrReihenfolge();
        }
        BigInteger _wert_2 = null;
        if (_fstrReihenfolge != null) {
            _wert_2 = _fstrReihenfolge.getWert();
        }
        if ((fstrReihenfolge = _wert_2.compareTo(BigInteger.ZERO)) == 0) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(fstrFahrwegStartSignalBezeichnung);
            _builder.append("/");
            _builder.append(fstrFahrwegZielSignalBezeichnung);
            return _builder.toString();
        }
        if (fstrReihenfolge > 0) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(fstrFahrwegStartSignalBezeichnung);
            _builder_1.append("/");
            _builder_1.append(fstrFahrwegZielSignalBezeichnung);
            _builder_1.append(" [U");
            String _string = fstrZugRangier.getFstrZugRangierAllg().getFstrReihenfolge().getWert().toString();
            _builder_1.append(_string);
            _builder_1.append("]");
            return _builder_1.toString();
        }
        return null;
    }

    public static String getZugFstrBezeichnung(Fstr_Zug_Rangier fstrZugRangier, Functions.Function1<? super Fstr_Zug_Rangier, ? extends Boolean> condition) {
        boolean _tripleNotEquals_1;
        Fstr_Mittel_AttributeGroup _fstrMittel;
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        boolean _not;
        Boolean _apply = (Boolean)condition.apply((Object)fstrZugRangier);
        boolean bl = _not = _apply == false;
        if (_not) {
            return null;
        }
        Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg = null;
        if (fstrZugRangier != null) {
            _fstrZugRangierAllg = fstrZugRangier.getFstrZugRangierAllg();
        }
        Fstr_Reihenfolge_TypeClass _fstrReihenfolge = null;
        if (_fstrZugRangierAllg != null) {
            _fstrReihenfolge = _fstrZugRangierAllg.getFstrReihenfolge();
        }
        BigInteger _wert = null;
        if (_fstrReihenfolge != null) {
            _wert = _fstrReihenfolge.getWert();
        }
        BigInteger fstrReihenfolge = _wert;
        boolean _or = false;
        boolean _or_1 = false;
        Fstr_DWeg _fstrDWeg = null;
        if (fstrZugRangier != null) {
            _fstrDWeg = FstrZugRangierExtensions.getFstrDWeg(fstrZugRangier);
        }
        boolean bl2 = _tripleEquals = _fstrDWeg == null;
        if (_tripleEquals) {
            _or_1 = true;
        } else {
            boolean _tripleEquals_1;
            Fstr_DWeg _fstrDWeg_1 = null;
            if (fstrZugRangier != null) {
                _fstrDWeg_1 = FstrZugRangierExtensions.getFstrDWeg(fstrZugRangier);
            }
            Fstr_DWeg_Spezifisch_AttributeGroup _fstrDWegSpezifisch = null;
            if (_fstrDWeg_1 != null) {
                _fstrDWegSpezifisch = _fstrDWeg_1.getFstrDWegSpezifisch();
            }
            _or_1 = _tripleEquals_1 = _fstrDWegSpezifisch == null;
        }
        _or = _or_1 ? true : (_tripleNotEquals = (_fstrMittel = fstrZugRangier.getFstrMittel()) != null);
        if (_or) {
            boolean _equals = Objects.equals(fstrReihenfolge, BigInteger.ZERO);
            if (_equals) {
                Fstr_Fahrweg _fstrFahrweg = null;
                if (fstrZugRangier != null) {
                    _fstrFahrweg = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
                }
                String _transformFahrwegStartZiel = null;
                if (_fstrFahrweg != null) {
                    _transformFahrwegStartZiel = FstrZugRangierExtensions.transformFahrwegStartZiel(_fstrFahrweg);
                }
                return _transformFahrwegStartZiel;
            }
            boolean _isNotNullAndGreater = BigIntegerExtensions.isNotNullAndGreater((BigInteger)fstrReihenfolge, (BigInteger)BigInteger.ZERO);
            if (_isNotNullAndGreater) {
                StringConcatenation _builder = new StringConcatenation();
                Fstr_Fahrweg _fstrFahrweg_1 = null;
                if (fstrZugRangier != null) {
                    _fstrFahrweg_1 = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
                }
                String _transformFahrwegStartZiel_1 = null;
                if (_fstrFahrweg_1 != null) {
                    _transformFahrwegStartZiel_1 = FstrZugRangierExtensions.transformFahrwegStartZiel(_fstrFahrweg_1);
                }
                _builder.append(_transformFahrwegStartZiel_1);
                _builder.append(" [U");
                Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg_1 = null;
                if (fstrZugRangier != null) {
                    _fstrZugRangierAllg_1 = fstrZugRangier.getFstrZugRangierAllg();
                }
                Fstr_Reihenfolge_TypeClass _fstrReihenfolge_1 = null;
                if (_fstrZugRangierAllg_1 != null) {
                    _fstrReihenfolge_1 = _fstrZugRangierAllg_1.getFstrReihenfolge();
                }
                BigInteger _wert_1 = null;
                if (_fstrReihenfolge_1 != null) {
                    _wert_1 = _fstrReihenfolge_1.getWert();
                }
                _builder.append((Object)_wert_1);
                _builder.append("]");
                return _builder.toString();
            }
        }
        Fstr_Zug_AttributeGroup _fstrZug = null;
        if (fstrZugRangier != null) {
            _fstrZug = fstrZugRangier.getFstrZug();
        }
        Fstr_Zug_DWeg_AttributeGroup _fstrZugDWeg = null;
        if (_fstrZug != null) {
            _fstrZugDWeg = _fstrZug.getFstrZugDWeg();
        }
        boolean bl3 = _tripleNotEquals_1 = _fstrZugDWeg != null;
        if (_tripleNotEquals_1) {
            boolean _equals_1 = Objects.equals(fstrReihenfolge, BigInteger.ZERO);
            if (_equals_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                Fstr_Fahrweg _fstrFahrweg_2 = null;
                if (fstrZugRangier != null) {
                    _fstrFahrweg_2 = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
                }
                String _transformFahrwegStartZiel_2 = null;
                if (_fstrFahrweg_2 != null) {
                    _transformFahrwegStartZiel_2 = FstrZugRangierExtensions.transformFahrwegStartZiel(_fstrFahrweg_2);
                }
                _builder_1.append(_transformFahrwegStartZiel_2);
                _builder_1.append(" (");
                Fstr_DWeg _fstrDWeg_2 = null;
                if (fstrZugRangier != null) {
                    _fstrDWeg_2 = FstrZugRangierExtensions.getFstrDWeg(fstrZugRangier);
                }
                Fstr_DWeg_Bezeichnung_AttributeGroup _bezeichnung = null;
                if (_fstrDWeg_2 != null) {
                    _bezeichnung = _fstrDWeg_2.getBezeichnung();
                }
                Bezeichnung_Fstr_DWeg_TypeClass _bezeichnungFstrDWeg = null;
                if (_bezeichnung != null) {
                    _bezeichnungFstrDWeg = _bezeichnung.getBezeichnungFstrDWeg();
                }
                String _wert_2 = null;
                if (_bezeichnungFstrDWeg != null) {
                    _wert_2 = _bezeichnungFstrDWeg.getWert();
                }
                _builder_1.append(_wert_2);
                _builder_1.append(")");
                return _builder_1.toString();
            }
            boolean _isNotNullAndGreater_1 = BigIntegerExtensions.isNotNullAndGreater((BigInteger)fstrReihenfolge, (BigInteger)BigInteger.ZERO);
            if (_isNotNullAndGreater_1) {
                StringConcatenation _builder_2 = new StringConcatenation();
                Fstr_Fahrweg _fstrFahrweg_3 = null;
                if (fstrZugRangier != null) {
                    _fstrFahrweg_3 = FstrZugRangierExtensions.getFstrFahrweg(fstrZugRangier);
                }
                String _transformFahrwegStartZiel_3 = null;
                if (_fstrFahrweg_3 != null) {
                    _transformFahrwegStartZiel_3 = FstrZugRangierExtensions.transformFahrwegStartZiel(_fstrFahrweg_3);
                }
                _builder_2.append(_transformFahrwegStartZiel_3);
                _builder_2.append(" [U");
                Fstr_Zug_Rangier_Allg_AttributeGroup _fstrZugRangierAllg_2 = null;
                if (fstrZugRangier != null) {
                    _fstrZugRangierAllg_2 = fstrZugRangier.getFstrZugRangierAllg();
                }
                Fstr_Reihenfolge_TypeClass _fstrReihenfolge_2 = null;
                if (_fstrZugRangierAllg_2 != null) {
                    _fstrReihenfolge_2 = _fstrZugRangierAllg_2.getFstrReihenfolge();
                }
                BigInteger _wert_3 = null;
                if (_fstrReihenfolge_2 != null) {
                    _wert_3 = _fstrReihenfolge_2.getWert();
                }
                _builder_2.append((Object)_wert_3);
                _builder_2.append("] (");
                Fstr_DWeg _fstrDWeg_3 = null;
                if (fstrZugRangier != null) {
                    _fstrDWeg_3 = FstrZugRangierExtensions.getFstrDWeg(fstrZugRangier);
                }
                Fstr_DWeg_Bezeichnung_AttributeGroup _bezeichnung_1 = null;
                if (_fstrDWeg_3 != null) {
                    _bezeichnung_1 = _fstrDWeg_3.getBezeichnung();
                }
                Bezeichnung_Fstr_DWeg_TypeClass _bezeichnungFstrDWeg_1 = null;
                if (_bezeichnung_1 != null) {
                    _bezeichnungFstrDWeg_1 = _bezeichnung_1.getBezeichnungFstrDWeg();
                }
                String _wert_4 = null;
                if (_bezeichnungFstrDWeg_1 != null) {
                    _wert_4 = _bezeichnungFstrDWeg_1.getWert();
                }
                _builder_2.append(_wert_4);
                _builder_2.append(")");
                return _builder_2.toString();
            }
        }
        return null;
    }

    private static boolean isVorsignalisierung(Fstr_Zug_Rangier fstrZugRangier, DirectedEdgePoint<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> edgePoint) {
        ENUMSignalArt signalArt;
        boolean _isInWirkrichtung;
        boolean _not_1;
        boolean _not;
        Punkt_Objekt punktObjekt = PunktObjektTopKanteExtensions.getPunktObjekt((Punkt_Objekt_TOP_Kante_AttributeGroup)edgePoint.getPoint());
        if (!(punktObjekt instanceof Signal)) {
            return false;
        }
        boolean _contains = edgePoint.getEdge().contains((Object)((Punkt_Objekt_TOP_Kante_AttributeGroup)edgePoint.getPoint()));
        boolean bl = _not = !_contains;
        if (_not) {
            return false;
        }
        Punkt_Objekt_TOP_Kante_AttributeGroup _point = (Punkt_Objekt_TOP_Kante_AttributeGroup)edgePoint.getPoint();
        Wirkrichtung_TypeClass _wirkrichtung = null;
        if (_point != null) {
            _wirkrichtung = _point.getWirkrichtung();
        }
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        boolean bl2 = _not_1 = !(_isInWirkrichtung = ENUMWirkrichtungExtensions.isInWirkrichtung(_wert, edgePoint.getEdge()));
        if (_not_1) {
            return false;
        }
        Signal signal = (Signal)punktObjekt;
        Signal_Real_AttributeGroup _signalReal = signal.getSignalReal();
        Signal_Real_Aktiv_Schirm_AttributeGroup _signalRealAktivSchirm = null;
        if (_signalReal != null) {
            _signalRealAktivSchirm = _signalReal.getSignalRealAktivSchirm();
        }
        Signal_Art_TypeClass _signalArt = null;
        if (_signalRealAktivSchirm != null) {
            _signalArt = _signalRealAktivSchirm.getSignalArt();
        }
        ENUMSignalArt _wert_1 = null;
        if (_signalArt != null) {
            _wert_1 = _signalArt.getWert();
        }
        if ((signalArt = _wert_1) != ENUMSignalArt.ENUM_SIGNAL_ART_VORSIGNAL && signalArt != ENUMSignalArt.ENUM_SIGNAL_ART_VORSIGNALWIEDERHOLER && !SignalExtensions.isAlleinstehendesZusatzsignal(signal)) {
            return false;
        }
        boolean _isKennlichtSignalisierung = FstrZugRangierExtensions.isKennlichtSignalisierung(fstrZugRangier, signal);
        return !_isKennlichtSignalisierung;
    }

    public static String transformFahrwegStartZiel(Fstr_Fahrweg fahrweg) {
        StringConcatenation _builder = new StringConcatenation();
        Signal _start = null;
        if (fahrweg != null) {
            _start = FahrwegExtensions.getStart(fahrweg);
        }
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (_start != null) {
            _bezeichnung = _start.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
        if (_bezeichnung != null) {
            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
        }
        String _wert = null;
        if (_bezeichnungTabelle != null) {
            _wert = _bezeichnungTabelle.getWert();
        }
        _builder.append(_wert);
        _builder.append("/");
        Signal _zielSignal = null;
        if (fahrweg != null) {
            _zielSignal = FahrwegExtensions.getZielSignal(fahrweg);
        }
        Bezeichnung_Element_AttributeGroup _bezeichnung_1 = null;
        if (_zielSignal != null) {
            _bezeichnung_1 = _zielSignal.getBezeichnung();
        }
        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle_1 = null;
        if (_bezeichnung_1 != null) {
            _bezeichnungTabelle_1 = _bezeichnung_1.getBezeichnungTabelle();
        }
        String _wert_1 = null;
        if (_bezeichnungTabelle_1 != null) {
            _wert_1 = _bezeichnungTabelle_1.getWert();
        }
        _builder.append(_wert_1);
        return _builder.toString();
    }

    public static boolean isZOrGz(Fstr_Zug_Art_TypeClass fstrZugArt) {
        String rangierArt;
        ENUMFstrZugArt _wert = null;
        if (fstrZugArt != null) {
            _wert = fstrZugArt.getWert();
        }
        String _literal = null;
        if (_wert != null) {
            _literal = _wert.getLiteral();
        }
        return (rangierArt = _literal).matches("Z.*") || rangierArt.matches("GZ.*");
    }

    public static boolean isZ(Fstr_Zug_Rangier fstrZug) {
        Fstr_Zug_AttributeGroup _fstrZug = null;
        if (fstrZug != null) {
            _fstrZug = fstrZug.getFstrZug();
        }
        Fstr_Zug_Art_TypeClass _fstrZugArt = null;
        if (_fstrZug != null) {
            _fstrZugArt = _fstrZug.getFstrZugArt();
        }
        ENUMFstrZugArt _wert = null;
        if (_fstrZugArt != null) {
            _wert = _fstrZugArt.getWert();
        }
        ENUMFstrZugArt zugArt = _wert;
        Fstr_Mittel_AttributeGroup _fstrMittel = null;
        if (fstrZug != null) {
            _fstrMittel = fstrZug.getFstrMittel();
        }
        Fstr_Mittel_Art_TypeClass _fstrMittelArt = null;
        if (_fstrMittel != null) {
            _fstrMittelArt = _fstrMittel.getFstrMittelArt();
        }
        ENUMFstrMittelArt _wert_1 = null;
        if (_fstrMittelArt != null) {
            _wert_1 = _fstrMittelArt.getWert();
        }
        ENUMFstrMittelArt fstrMittleArt = _wert_1;
        Functions.Function1 _function = it -> ((Enumerator)it).getLiteral() != null && ((Enumerator)it).getLiteral().matches("Z.*");
        return org.eclipse.xtext.xbase.lib.IterableExtensions.exists((Iterable)org.eclipse.xtext.xbase.lib.IterableExtensions.filterNull(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Enum[]{zugArt, fstrMittleArt}))), (Functions.Function1)_function);
    }

    public static boolean isR(Fstr_Zug_Rangier fstrZugRangier) {
        Fstr_Rangier_AttributeGroup _fstrRangier = null;
        if (fstrZugRangier != null) {
            _fstrRangier = fstrZugRangier.getFstrRangier();
        }
        Fstr_Rangier_Art_TypeClass _fstrRangierArt = null;
        if (_fstrRangier != null) {
            _fstrRangierArt = _fstrRangier.getFstrRangierArt();
        }
        ENUMFstrRangierArt _wert = null;
        if (_fstrRangierArt != null) {
            _wert = _fstrRangierArt.getWert();
        }
        String _literal = null;
        if (_wert != null) {
            _literal = _wert.getLiteral();
        }
        String _substring = null;
        if (_literal != null) {
            _substring = _literal.substring(0, 1);
        }
        return Objects.equals(_substring, "R");
    }

    private static int _getVmax(Object object, Fstr_Fahrweg fw) {
        return -1;
    }

    private static int _getVmax(W_Kr_Gsp_Komponente object, Fstr_Fahrweg fw) {
        Kreuzung_AttributeGroup kreuzung = object.getKreuzung();
        Zungenpaar_AttributeGroup zungenpaar = object.getZungenpaar();
        if (kreuzung != null && zungenpaar == null) {
            return FstrZugRangierExtensions.getVmaxKreuzung(kreuzung, fw);
        }
        if (kreuzung == null && zungenpaar != null) {
            return FstrZugRangierExtensions.getVmaxWeiche(zungenpaar, FahrwegExtensions.getWeichenSchenkel(fw, object));
        }
        return Integer.MAX_VALUE;
    }

    private static int _getVmax(Gleis_Abschnitt object, Fstr_Fahrweg fw) {
        BigInteger geschwindigkeit;
        Geschwindigkeit_TypeClass _geschwindigkeit = object.getGeschwindigkeit();
        BigInteger _wert = null;
        if (_geschwindigkeit != null) {
            _wert = _geschwindigkeit.getWert();
        }
        if ((geschwindigkeit = _wert) != null) {
            return geschwindigkeit.intValue();
        }
        return -1;
    }

    private static int getVmaxKreuzung(Kreuzung_AttributeGroup object, Fstr_Fahrweg fw) {
        CrossingRoute crossingRoute = FahrwegExtensions.getCrossingRoute(fw, object);
        boolean _equals = Objects.equals((Object)crossingRoute, (Object)CrossingRoute.LEFT);
        if (_equals) {
            return object.getGeschwindigkeitL().getWert().intValue();
        }
        boolean _equals_1 = Objects.equals((Object)crossingRoute, (Object)CrossingRoute.RIGHT);
        if (_equals_1) {
            return object.getGeschwindigkeitR().getWert().intValue();
        }
        String _string = crossingRoute.toString();
        throw new IllegalArgumentException(_string);
    }

    private static int getVmaxWeiche(Zungenpaar_AttributeGroup object, WeichenSchenkel schenkel) {
        if (schenkel.lage == WeichenSchenkel.Lage.L) {
            BigInteger _elvis = null;
            Geschwindigkeit_L_TypeClass _geschwindigkeitL = null;
            if (object != null) {
                _geschwindigkeitL = object.getGeschwindigkeitL();
            }
            BigInteger _wert = null;
            if (_geschwindigkeitL != null) {
                _wert = _geschwindigkeitL.getWert();
            }
            _elvis = _wert != null ? _wert : BigInteger.ZERO;
            return _elvis.intValue();
        }
        BigInteger _elvis_1 = null;
        Geschwindigkeit_R_TypeClass _geschwindigkeitR = null;
        if (object != null) {
            _geschwindigkeitR = object.getGeschwindigkeitR();
        }
        BigInteger _wert_1 = null;
        if (_geschwindigkeitR != null) {
            _wert_1 = _geschwindigkeitR.getWert();
        }
        _elvis_1 = _wert_1 != null ? _wert_1 : BigInteger.ZERO;
        return _elvis_1.intValue();
    }

    public static boolean isBelongToControlArea(Fstr_Zug_Rangier fstrZugRangier, Stell_Bereich controlArea) {
        boolean _isR = FstrZugRangierExtensions.isR(fstrZugRangier);
        if (_isR) {
            return FstrZugRangierExtensions.isRangierStrBelongToControlArea(fstrZugRangier, controlArea);
        }
        boolean _isZ = FstrZugRangierExtensions.isZ(fstrZugRangier);
        if (_isZ) {
            return FstrZugRangierExtensions.isZugStrBelongToControlArea(fstrZugRangier, controlArea);
        }
        return false;
    }

    private static boolean isRangierStrBelongToControlArea(Fstr_Zug_Rangier fstrZugRangier, Stell_Bereich controlArea) {
        boolean _tripleEquals;
        Fstr_Rangier_AttributeGroup _fstrRangier = null;
        if (fstrZugRangier != null) {
            _fstrRangier = fstrZugRangier.getFstrRangier();
        }
        boolean bl = _tripleEquals = _fstrRangier == null;
        if (_tripleEquals) {
            return false;
        }
        ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg = null;
        if (fstrZugRangier != null) {
            _iDFstrFahrweg = fstrZugRangier.getIDFstrFahrweg();
        }
        Fstr_Fahrweg _value = null;
        if (_iDFstrFahrweg != null) {
            _value = _iDFstrFahrweg.getValue();
        }
        ID_Signal_TypeClass _iDStart = null;
        if (_value != null) {
            _iDStart = _value.getIDStart();
        }
        Signal _value_1 = null;
        if (_iDStart != null) {
            _value_1 = _iDStart.getValue();
        }
        Signal startSignal = _value_1;
        return StellBereichExtensions.isInControlArea(controlArea, (Basis_Objekt)startSignal);
    }

    private static boolean isZugStrBelongToControlArea(Fstr_Zug_Rangier fstrZugRangier, Stell_Bereich controlArea) {
        boolean _tripleEquals;
        boolean _and = false;
        Fstr_Zug_AttributeGroup _fstrZug = null;
        if (fstrZugRangier != null) {
            _fstrZug = fstrZugRangier.getFstrZug();
        }
        boolean bl = _tripleEquals = _fstrZug == null;
        if (!_tripleEquals) {
            _and = false;
        } else {
            boolean _tripleEquals_1;
            Fstr_Mittel_AttributeGroup _fstrMittel = null;
            if (fstrZugRangier != null) {
                _fstrMittel = fstrZugRangier.getFstrMittel();
            }
            _and = _tripleEquals_1 = _fstrMittel == null;
        }
        if (_and) {
            return false;
        }
        ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg = null;
        if (fstrZugRangier != null) {
            _iDFstrFahrweg = fstrZugRangier.getIDFstrFahrweg();
        }
        Fstr_Fahrweg _value = null;
        if (_iDFstrFahrweg != null) {
            _value = _iDFstrFahrweg.getValue();
        }
        ID_Signal_TypeClass _iDStart = null;
        if (_value != null) {
            _iDStart = _value.getIDStart();
        }
        Signal _value_1 = null;
        if (_iDStart != null) {
            _value_1 = _iDStart.getValue();
        }
        Signal startSignal = _value_1;
        ID_Fstr_Fahrweg_TypeClass _iDFstrFahrweg_1 = null;
        if (fstrZugRangier != null) {
            _iDFstrFahrweg_1 = fstrZugRangier.getIDFstrFahrweg();
        }
        Fstr_Fahrweg _value_2 = null;
        if (_iDFstrFahrweg_1 != null) {
            _value_2 = _iDFstrFahrweg_1.getValue();
        }
        ID_Ziel_TypeClass _iDZiel = null;
        if (_value_2 != null) {
            _iDZiel = _value_2.getIDZiel();
        }
        Basis_Objekt _value_3 = null;
        if (_iDZiel != null) {
            _value_3 = _iDZiel.getValue();
        }
        Basis_Objekt zielSignal = _value_3;
        if (startSignal == null && zielSignal == null) {
            return false;
        }
        return startSignal != null && SignalExtensions.isBelongToControlArea(startSignal, controlArea);
    }

    @XbaseGenerated
    private static int getVmax(Object object, Fstr_Fahrweg fw) {
        if (object instanceof Gleis_Abschnitt) {
            return FstrZugRangierExtensions._getVmax((Gleis_Abschnitt)object, fw);
        }
        if (object instanceof W_Kr_Gsp_Komponente) {
            return FstrZugRangierExtensions._getVmax((W_Kr_Gsp_Komponente)object, fw);
        }
        if (object != null) {
            return FstrZugRangierExtensions._getVmax(object, fw);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(object, fw).toString());
    }
}

