/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import java.util.function.Function;
import org.eclipse.set.basis.attachments.Attachment;
import org.eclipse.set.basis.attachments.AttachmentInfo;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang_Art_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.BasisobjekteFactory;
import org.eclipse.set.model.planpro.Basisobjekte.Dateiname_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Dateityp_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.ENUMAnhangArt;
import org.eclipse.set.model.planpro.Basisobjekte.ENUMDateityp;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.xtend2.lib.StringConcatenation;

public class AttachmentExtensions {
    public static AttachmentInfo<Anhang> createAnhang(AttachmentInfo<Attachment> attachmentInfo) {
        Function<Anhang, Guid> _function;
        Anhang_Allg_AttributeGroup anhangAllg = BasisobjekteFactory.eINSTANCE.createAnhang_Allg_AttributeGroup();
        Attachment attachment = (Attachment)attachmentInfo.element;
        anhangAllg.setAnhangArt(AttachmentExtensions.transformToAnhangArt(attachment));
        anhangAllg.setDateiname(AttachmentExtensions.transformToDateiname(attachment));
        anhangAllg.setDateityp(AttachmentExtensions.transformToDateityp(attachment));
        AttachmentInfo info = new AttachmentInfo();
        boolean _hasDetachedAttachments = attachmentInfo.toolboxFile.hasDetachedAttachments();
        if (_hasDetachedAttachments) {
            info.data = attachment.getData();
        }
        info.toolboxFile = attachmentInfo.toolboxFile;
        info.guidProvider = _function = a -> Guid.create((String)a.getIdentitaet().getWert());
        Anhang anhang = BasisobjekteFactory.eINSTANCE.createAnhang();
        anhang.setIdentitaet(AttachmentExtensions.transformToIdentitaet(attachment));
        anhang.setAnhangAllg(anhangAllg);
        info.element = anhang;
        return info;
    }

    public static ENUMAnhangArt transformToAnhangArtWert(Attachment attachment) {
        ENUMAnhangArt result = ENUMAnhangArt.get((int)attachment.getFileKind().getId());
        if (result == null) {
            result = ENUMAnhangArt.ENUM_ANHANG_ART_SONSTIGE;
        }
        return result;
    }

    public static ENUMDateityp transformToDateitypWert(Attachment attachment) {
        ENUMDateityp result = ENUMDateityp.get((String)attachment.getFileExtension().toLowerCase());
        if (result == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Unsupported filetype \"");
            String _fileExtension = attachment.getFileExtension();
            _builder.append(_fileExtension);
            _builder.append("\"");
            throw new IllegalArgumentException(_builder.toString());
        }
        return result;
    }

    private static Anhang_Art_TypeClass transformToAnhangArt(Attachment attachment) {
        Anhang_Art_TypeClass anhangArt = BasisobjekteFactory.eINSTANCE.createAnhang_Art_TypeClass();
        anhangArt.setWert(AttachmentExtensions.transformToAnhangArtWert(attachment));
        return anhangArt;
    }

    private static Dateiname_TypeClass transformToDateiname(Attachment attachment) {
        Dateiname_TypeClass dateiname = BasisobjekteFactory.eINSTANCE.createDateiname_TypeClass();
        dateiname.setWert(attachment.getBaseFilename());
        return dateiname;
    }

    private static Dateityp_TypeClass transformToDateityp(Attachment attachment) {
        Dateityp_TypeClass dateityp = BasisobjekteFactory.eINSTANCE.createDateityp_TypeClass();
        dateityp.setWert(AttachmentExtensions.transformToDateitypWert(attachment));
        return dateityp;
    }

    private static Identitaet_TypeClass transformToIdentitaet(Attachment attachment) {
        Identitaet_TypeClass identitaet = BasisobjekteFactory.eINSTANCE.createIdentitaet_TypeClass();
        identitaet.setWert(attachment.getId());
        return identitaet;
    }
}

