/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emfcloud.jackson.databind.EMFContext;

public class EMapValueSerializer
extends JsonSerializer<Object> {
    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        EStructuralFeature feature = EMFContext.getFeature((DatabindContext)serializers);
        Optional<EReference> mapRef = Optional.ofNullable(feature).filter(EReference.class::isInstance).map(EReference.class::cast);
        Optional<EStructuralFeature> valueFeature = mapRef.map(EReference::getEReferenceType).map(mapType -> mapType.getEStructuralFeature("value")).filter(Objects::nonNull);
        Optional<EDataType> valueDataType = valueFeature.filter(EAttribute.class::isInstance).map(EAttribute.class::cast).map(EAttribute::getEAttributeType);
        Optional<EClass> valueEClass = valueFeature.filter(EReference.class::isInstance).map(EReference.class::cast).map(EReference::getEReferenceType);
        if (valueDataType.isPresent()) {
            gen.writeString(EcoreUtil.convertToString((EDataType)valueDataType.get(), (Object)value));
        } else if (valueEClass.isPresent() && value instanceof EObject) {
            gen.writeObject(value);
        } else {
            gen.writeString(value.toString());
        }
    }
}

