/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.core.services.geometry.PointObjectPositionService;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.TransformUtils;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Aussenelementansteuerung;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Aussenelementansteuerung_Bezeichnung_AttributeGroup;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Bezeichnung_AEA_TypeClass;
import org.eclipse.set.model.planpro.Ansteuerung_Element.ENUMAussenelementansteuerungArt;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Unterbringung;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_Strecke_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Bedienung.Bedien_Platz;
import org.eclipse.set.model.planpro.Bedienung.ENUMBedienPlatzArt;
import org.eclipse.set.model.siteplan.ControlStationType;
import org.eclipse.set.model.siteplan.ExternalElementControl;
import org.eclipse.set.model.siteplan.ExternalElementControlArt;
import org.eclipse.set.model.siteplan.Label;
import org.eclipse.set.model.siteplan.RouteObject;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.ppmodel.extensions.AussenelementansteuerungExtensions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class ExternalElementControlTransform
extends BaseTransformator<Aussenelementansteuerung> {
    @Reference
    private PointObjectPositionService pointObjectPositionService;
    @Reference
    private PositionService positionService;
    private static final String ERROR_NO_UNTERBRINGUNG = "Keine Unterbringung f\u00fcr Aussenelementansteuerung '%s' gefunden";

    @Override
    public void transform(Aussenelementansteuerung aea) {
        GEOKanteCoordinate coordinate;
        ExternalElementControl result = SiteplanFactory.eINSTANCE.createExternalElementControl();
        result.setGuid(aea.getIdentitaet().getWert());
        result.setLabel(SiteplanFactory.eINSTANCE.createLabel());
        Label _label = result.getLabel();
        Aussenelementansteuerung_Bezeichnung_AttributeGroup _bezeichnung = aea.getBezeichnung();
        Bezeichnung_AEA_TypeClass _bezeichnungAEA = null;
        if (_bezeichnung != null) {
            _bezeichnungAEA = _bezeichnung.getBezeichnungAEA();
        }
        String _wert = null;
        if (_bezeichnungAEA != null) {
            _wert = _bezeichnungAEA.getWert();
        }
        _label.setText(_wert);
        result.setElementType(this.transformControlArt(aea));
        Unterbringung _unterbringung = AussenelementansteuerungExtensions.getUnterbringung((Aussenelementansteuerung)aea);
        Punkt_Objekt_TOP_Kante_AttributeGroup _punktObjektTOPKante = null;
        if (_unterbringung != null) {
            _punktObjektTOPKante = _unterbringung.getPunktObjektTOPKante();
        }
        if ((coordinate = this.pointObjectPositionService.getCoordinate(_punktObjektTOPKante)) == null) {
            this.recordError(result.getGuid(), String.format(ERROR_NO_UNTERBRINGUNG, result.getGuid()));
            return;
        }
        result.setPosition(this.positionService.transformPosition(coordinate));
        result.setControlStation(this.transformControlStation(aea));
        Unterbringung _unterbringung_1 = AussenelementansteuerungExtensions.getUnterbringung((Aussenelementansteuerung)aea);
        EList _punktObjektStrecke = null;
        if (_unterbringung_1 != null) {
            _punktObjektStrecke = _unterbringung_1.getPunktObjektStrecke();
        }
        if (_punktObjektStrecke != null) {
            TransformUtils.transformPunktObjektStrecke((EList<Punkt_Objekt_Strecke_AttributeGroup>)_punktObjektStrecke, (RouteObject)result);
        }
        this.addSiteplanElement(result, SiteplanPackage.eINSTANCE.getSiteplanState_ExternalElementControls());
    }

    public ExternalElementControlArt transformControlArt(Aussenelementansteuerung aussenelementansteuerung) {
        ENUMAussenelementansteuerungArt _wert = aussenelementansteuerung.getAEAAllg().getAussenelementansteuerungArt().getWert();
        if (_wert != null) {
            switch (_wert) {
                case ENUM_AUSSENELEMENTANSTEUERUNG_ART_ESTW_A: {
                    return ExternalElementControlArt.ESTW_A;
                }
                case ENUM_AUSSENELEMENTANSTEUERUNG_ART_FE_AK: {
                    return ExternalElementControlArt.FE_AK;
                }
                case ENUM_AUSSENELEMENTANSTEUERUNG_ART_GFK: {
                    return ExternalElementControlArt.GFK;
                }
                case ENUM_AUSSENELEMENTANSTEUERUNG_ART_GLEISFREIMELDE_INNENANLAGE: {
                    return ExternalElementControlArt.GLEISFREIMELDE_INNENANLAGE;
                }
                case ENUM_AUSSENELEMENTANSTEUERUNG_ART_OBJEKTCONTROLLER: {
                    return ExternalElementControlArt.OBJEKTCONTROLLER;
                }
                case ENUM_AUSSENELEMENTANSTEUERUNG_ART_SONSTIGE: {
                    return ExternalElementControlArt.SONSTIGE;
                }
                case ENUM_AUSSENELEMENTANSTEUERUNG_ART_VIRTUELLE_AUSSENELEMENTANSTEUERUNG: {
                    return ExternalElementControlArt.VIRTUELLE_AUSSENELEMENTANSTEUERUNG;
                }
            }
            return null;
        }
        return null;
    }

    public ControlStationType transformControlStation(Aussenelementansteuerung aea) {
        Functions.Function1 _function = it -> {
            Unterbringung _unterbringung;
            Unterbringung _value = it.getIDUnterbringung().getValue();
            return _value == (_unterbringung = AussenelementansteuerungExtensions.getUnterbringung((Aussenelementansteuerung)aea));
        };
        Bedien_Platz controlStation = (Bedien_Platz)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)this.container.getAllContents(), Bedien_Platz.class), (Functions.Function1)_function);
        if (controlStation == null) {
            return ControlStationType.WITHOUT_CONTROL;
        }
        ENUMBedienPlatzArt _wert = controlStation.getBedienPlatzAllg().getBedienPlatzArt().getWert();
        if (_wert != null) {
            switch (_wert) {
                case ENUM_BEDIEN_PLATZ_ART_NOT_BPS: {
                    return ControlStationType.EMERGENCY_CONTROL;
                }
                case ENUM_BEDIEN_PLATZ_ART_NOT_BPS_ABGESETZT: {
                    return ControlStationType.EMERGENCY_CONTROL_DISPOSE;
                }
                case ENUM_BEDIEN_PLATZ_ART_STANDARD_BPS: {
                    return ControlStationType.DEFAULT_CONTROL;
                }
                case ENUM_BEDIEN_PLATZ_ART_STANDARD_BPS_ABGESETZT: {
                    return ControlStationType.DEFAULT_CONTROL_DISPOSE;
                }
                case ENUM_BEDIEN_PLATZ_ART_SONSTIGE: {
                    return ControlStationType.OTHER;
                }
            }
        }
        return null;
    }
}

