/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.planpro.BasisTypen.BasisAttribut_AttributeGroup;
import org.eclipse.set.model.planpro.BasisTypen.ID_Bearbeitungsvermerk_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang_Art_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.PlanPro.PlanProPackage;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.osgi.service.component.annotations.Component;

@Component
public class SonstigeRequiresBearbeitungsvermerk
implements PlazCheck {
    private static final String SONSTIGE_ENUM_WERT = "sonstige";
    private static final String ENUM_WERT_FEATURE_NAME = "wert";
    private static final String BEARBEITUNGSVERMERK_FEATURE_NAME = "iDBearbeitungsvermerk";

    @Override
    public List<PlazError> run(IModelSession modelSession) {
        TreeIterator contents = modelSession.getPlanProSchnittstelle().eAllContents();
        UnmodifiableIterator attributes = Iterators.filter((Iterator)contents, BasisAttribut_AttributeGroup.class);
        UnmodifiableIterator attributesWithSonstige = Iterators.filter((Iterator)attributes, this::isSonstigeEnumWert);
        UnmodifiableIterator attributesWithMissingBearbeitungsvermerk = Iterators.filter((Iterator)attributesWithSonstige, this::hasNoBearbeitungsVermerk);
        Iterator errors = Iterators.transform((Iterator)attributesWithMissingBearbeitungsvermerk, this::createError);
        return Lists.newArrayList((Iterator)errors);
    }

    private boolean isSonstigeEnumWert(BasisAttribut_AttributeGroup attribute) {
        try {
            Enumerator enumValue;
            EStructuralFeature feature = attribute.eClass().getEStructuralFeature(ENUM_WERT_FEATURE_NAME);
            Object value = attribute.eGet(feature);
            return value instanceof Enumerator && (enumValue = (Enumerator)value).getLiteral().equals(SONSTIGE_ENUM_WERT) && !SonstigeRequiresBearbeitungsvermerk.isPlanungBueroAnhangArt(attribute);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isPlanungBueroAnhangArt(BasisAttribut_AttributeGroup attribute) {
        Anhang_Allg_AttributeGroup allgGroup;
        EObject eObject;
        Anhang_Art_TypeClass anhangArt;
        EObject eObject2;
        if (attribute instanceof Anhang_Art_TypeClass && (eObject2 = (anhangArt = (Anhang_Art_TypeClass)attribute).eContainer()) instanceof Anhang_Allg_AttributeGroup && (eObject = (allgGroup = (Anhang_Allg_AttributeGroup)eObject2).eContainer()) instanceof Anhang) {
            Anhang anhang = (Anhang)eObject;
            EReference planungbueroLogoRef = PlanProPackage.eINSTANCE.getPlanung_G_Schriftfeld_AttributeGroup_PlanungsbueroLogo();
            return anhang.eContainingFeature().equals(planungbueroLogoRef);
        }
        return false;
    }

    private boolean hasNoBearbeitungsVermerk(EObject obj) {
        EList list;
        Object object;
        boolean hasBearbeitungsVermerk;
        EStructuralFeature feature = obj.eClass().getEStructuralFeature(BEARBEITUNGSVERMERK_FEATURE_NAME);
        boolean bl = hasBearbeitungsVermerk = feature != null && (object = obj.eGet(feature)) instanceof EList && !(list = (EList)object).isEmpty() && list.get(0) instanceof ID_Bearbeitungsvermerk_TypeClass;
        if (!hasBearbeitungsVermerk && !(obj instanceof Ur_Objekt)) {
            return this.hasNoBearbeitungsVermerk(obj.eContainer());
        }
        return !hasBearbeitungsVermerk;
    }

    private PlazError createError(BasisAttribut_AttributeGroup attribute) {
        PlazError err = PlazFactory.eINSTANCE.createPlazError();
        err.setMessage(this.getGeneralErrMsg());
        err.setType(this.checkType());
        err.setObject((EObject)attribute);
        err.setSeverity(ValidationSeverity.ERROR);
        return err;
    }

    @Override
    public String checkType() {
        return "Bearbeitungsvermerk";
    }

    @Override
    public String getDescription() {
        return String.format("Alles mit Referenz '%s' hat einen Bearbeitungsvermerk.", SONSTIGE_ENUM_WERT);
    }

    @Override
    public String getGeneralErrMsg() {
        return String.format("Fehlender Bearbeitungsvermerk bei Wert '%s'.", SONSTIGE_ENUM_WERT);
    }
}

