/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.Iterator;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;
import org.apfloat.AprationalMath;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.spi.Util;

class HurwitzZetaHelper {
    HurwitzZetaHelper() {
    }

    public static Apcomplex zeta(Apcomplex s, Apcomplex a) {
        Apint N;
        int radix = a.radix();
        Apint one = new Apint(1L, radix);
        if (s.equals(one)) {
            throw new ArithmeticException("Zeta of first argument one");
        }
        if (s.real().signum() == 0 && s.imag().signum() == 0 && a.real().signum() == 0 && a.imag().signum() == 0) {
            Apint two = new Apint(2L, radix);
            return new Aprational(one, two);
        }
        long precision = Math.min(s.precision(), a.precision());
        if (a.isInteger() && a.real().signum() <= 0) {
            if (s.real().signum() < 0 || s.real().signum() == 0 && s.imag().signum() == 0) {
                Apcomplex t = Apcomplex.ZERO;
                long i = a.longValueExact();
                while (i++ <= 0L) {
                    t = t.add(ApcomplexMath.pow(a, s.negate()));
                    a = a.add(one);
                }
                a = a.precision(precision);
                return t.add(HurwitzZetaHelper.zeta(s, a).precision(precision));
            }
            throw new ArithmeticException("Zeta of second argument nonpositive integer");
        }
        if (precision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate zeta function to infinite precision");
        }
        long doublePrecision = ApfloatHelper.getDoublePrecision(radix);
        long zetaScale = Math.min(0L, HurwitzZetaHelper.zetaScale(s.precision(doublePrecision), a.precision(doublePrecision)));
        Apint M = N = HurwitzZetaHelper.binarySearch(ApfloatHelper.limitPrecision(s, doublePrecision), ApfloatHelper.limitPrecision(a, doublePrecision), precision, -Util.ifFinite(-zetaScale, precision - zetaScale));
        s = ApfloatHelper.extendPrecision(s);
        a = ApfloatHelper.extendPrecision(a);
        Apcomplex S = HurwitzZetaHelper.S(s, a, N.longValueExact());
        Apcomplex I = HurwitzZetaHelper.I(s, a, N);
        Apcomplex T = HurwitzZetaHelper.T(s, a, N, M.longValueExact());
        return ApfloatHelper.reducePrecision(S.add(I).add(T));
    }

    private static long zetaScale(Apcomplex s, Apcomplex a) {
        long extraPrecision = Math.max(0L, Math.max(s.scale(), a.scale()));
        Apint one = Apint.ONES[a.radix()];
        s = ApfloatHelper.extendPrecision(s, extraPrecision);
        a = ApfloatHelper.extendPrecision(a, extraPrecision);
        return ApcomplexMath.pow(a, one.subtract(s)).divide(s.subtract(one)).scale();
    }

    private static Apint binarySearch(Apcomplex s, Apcomplex a, long precision, long targetScale) {
        long M;
        int radix = a.radix();
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apint min = ApintMath.max(two.subtract(a.real().truncate()), one.subtract(s.real()).divide(two).truncate().add(one));
        Apint N = ApintMath.max(new Apint(precision, radix), min);
        long low = M = N.longValueExact();
        long high = M;
        Apfloat R = HurwitzZetaHelper.R(s, a, N, M);
        while (R.scale() >= targetScale) {
            low = M;
            M = Math.multiplyExact(2L, M);
            N = new Apint(M, radix);
            R = HurwitzZetaHelper.R(s, a, N, M);
            high = M;
        }
        if (low == high) {
            long lowLimit = Math.max(0L, min.longValueExact());
            while (R.scale() < targetScale && M > lowLimit) {
                high = M;
                M = Math.max(M >> 1, lowLimit);
                N = new Apint(M, radix);
                R = HurwitzZetaHelper.R(s, a, N, M);
                low = M;
            }
        }
        while (high - low > 1L) {
            M = high + low >>> 1;
            N = new Apint(M, radix);
            R = HurwitzZetaHelper.R(s, a, N, M);
            if (R.scale() >= targetScale) {
                low = M;
                continue;
            }
            high = M;
        }
        return new Apint(high, radix);
    }

    private static Apfloat R(Apcomplex s, Apcomplex a, Apint N, long M) {
        int radix = a.radix();
        Apint two = new Apint(2L, radix);
        Apint four = new Apint(4L, radix);
        Apint M2 = new Apint(2L * M, radix);
        Apfloat \u03c3 = s.real();
        Apfloat \u03c4 = s.imag();
        Apfloat \u03b1 = a.real();
        Apfloat \u03b2 = a.imag();
        Apfloat pi = ApfloatMath.pi(ApfloatHelper.getDoublePrecision(radix), radix);
        Apfloat K = ApfloatMath.exp(ApfloatMath.max(Apfloat.ZEROS[radix], HurwitzZetaHelper.expPrecision(\u03c4.multiply(ApfloatMath.atan(\u03b2.divide(\u03b1.add(N)))))));
        Apfloat R = K.multiply(HurwitzZetaHelper.J(N.add(\u03b1), \u03c3.add(M2)));
        return four.multiply(ApcomplexMath.abs(HurwitzZetaHelper.pochhammer(s, 2L * M))).divide(ApfloatMath.pow(two.multiply(pi), 2L * M)).multiply(ApfloatMath.abs(R));
    }

    private static Apfloat J(Apfloat A, Apfloat B) {
        Apint one = Apint.ONES[A.radix()];
        Apfloat B1 = B.subtract(one);
        return one.divide(B1.multiply(ApfloatMath.pow(A, B1)));
    }

    private static Apcomplex pochhammer(Apcomplex s, long n) {
        Apint one;
        Apcomplex p = one = Apcomplex.ONES[s.radix()];
        int k = 0;
        while ((long)k < n) {
            p = p.multiply(s);
            s = s.add(one);
            ++k;
        }
        return p;
    }

    private static Apcomplex S(Apcomplex s, Apcomplex a, long N) {
        int radix = a.radix();
        Apcomplex sum = Apcomplex.ZEROS[radix];
        for (long k = 0L; k < N; ++k) {
            sum = sum.add(ApcomplexMath.pow(a.add(new Apint(k, radix)), s.negate()));
        }
        return sum;
    }

    private static Apcomplex I(Apcomplex s, Apcomplex a, Apint N) {
        int radix = a.radix();
        Apint one = Apint.ONES[radix];
        return ApcomplexMath.pow(a.add(N), one.subtract(s)).divide(s.subtract(one));
    }

    private static Apcomplex T(Apcomplex s, Apcomplex a, Apint N, long M) {
        int radix = a.radix();
        Apint one = Apint.ONES[radix];
        Apcomplex sum = new Aprational(one, new Apint(2L, radix));
        Apcomplex aN = a.add(N);
        Apcomplex aN2 = ApcomplexMath.pow(aN, -2L);
        Apcomplex pochhammer = s;
        Apcomplex factor = pochhammer.divide(aN);
        Iterator<Aprational> bernoullis = AprationalMath.bernoullis2(M, radix);
        for (long k = 1L; k <= M; ++k) {
            factor = factor.divide(new Apint(2L * k - 1L, radix).multiply(new Apint(2L * k, radix)));
            sum = sum.add(bernoullis.next().multiply(factor));
            if (k >= M) continue;
            pochhammer = pochhammer.add(one);
            factor = factor.multiply(pochhammer);
            pochhammer = pochhammer.add(one);
            factor = factor.multiply(pochhammer).multiply(aN2);
        }
        return sum.multiply(ApcomplexMath.pow(aN, s.negate()));
    }

    private static Apfloat expPrecision(Apfloat x) {
        return ApfloatHelper.extendPrecision(x, Math.max(0L, x.scale()));
    }
}

