/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.ppimport.control;

import java.util.List;
import java.util.stream.Stream;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.exceptions.UserAbortion;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.feature.projectdata.ppimport.control.ImportModelControl;
import org.eclipse.set.feature.projectdata.utils.AbstractImportControl;
import org.eclipse.set.feature.projectdata.utils.AbstractImportGroup;
import org.eclipse.set.feature.projectdata.utils.ImportComboFileField;
import org.eclipse.set.feature.projectdata.utils.ServiceProvider;
import org.eclipse.set.utils.widgets.Option;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;

public class ImportContainerControlGroup
extends AbstractImportGroup {
    private ImportModelControl importInitial;
    private ImportModelControl importFinal;
    private Option initialOption;
    private Option finalOption;

    public ImportContainerControlGroup(ServiceProvider serviceProvider, IModelSession modelSession, IEventBroker broker) {
        super(serviceProvider, modelSession, broker);
    }

    @Override
    public void createControl(Composite parent, Shell shell, ToolboxFileRole role) {
        Group group = ImportContainerControlGroup.createGroup(parent, shell, this.serviceProvider.messages.PlanProImportPart_importContainerGroup);
        this.createImportOption((Composite)group, ImportModelControl.ImportTarget.INITIAL);
        this.createImportContainerControl((Composite)group, shell, ToolboxFileRole.IMPORT_INITIAL_STATE, ImportModelControl.ImportTarget.INITIAL);
        this.createImportOption((Composite)group, ImportModelControl.ImportTarget.FINAL);
        this.createImportContainerControl((Composite)group, shell, ToolboxFileRole.IMPORT_FINAL_STATE, ImportModelControl.ImportTarget.FINAL);
        this.createImportButton((Composite)group, this.serviceProvider.messages.PlanpRoImportPart_importContainerButton);
    }

    private void createImportContainerControl(Composite parent, Shell shell, ToolboxFileRole role, ImportModelControl.ImportTarget importTarget) {
        ImportModelControl importControl = new ImportModelControl(this.serviceProvider, this.modelSession, importTarget, this::updateImportButton);
        importControl.createControl(parent, shell, role);
        if (importTarget == ImportModelControl.ImportTarget.INITIAL) {
            this.importInitial = importControl;
        } else {
            this.importFinal = importControl;
        }
    }

    private Option createImportOption(Composite parent, final ImportModelControl.ImportTarget target) {
        final Option checkbox = new Option(parent);
        checkbox.getLabel().setText(this.getOptionLabel(target));
        checkbox.getButton().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ImportComboFileField comboField = ImportContainerControlGroup.this.getComboField(target);
                if (comboField == null) {
                    return;
                }
                comboField.setEnabled(checkbox.getButton().getSelection());
                ImportContainerControlGroup.this.updateImportButton();
            }

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        if (target == ImportModelControl.ImportTarget.INITIAL) {
            this.initialOption = checkbox;
        } else {
            this.finalOption = checkbox;
        }
        return checkbox;
    }

    private String getOptionLabel(ImportModelControl.ImportTarget target) {
        switch (target) {
            case INITIAL: {
                return this.serviceProvider.messages.PlanProImportPart_importInitial;
            }
            case FINAL: {
                return this.serviceProvider.messages.PlanProImportPart_importFinal;
            }
        }
        throw new IllegalArgumentException();
    }

    private ImportComboFileField getComboField(ImportModelControl.ImportTarget target) {
        switch (target) {
            case INITIAL: {
                return this.importInitial.getComboField();
            }
            case FINAL: {
                return this.importFinal.getComboField();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void doImport(Shell shell) {
        List<ImportModelControl> controlList = List.of(this.importInitial, this.importFinal);
        controlList.forEach(control -> control.doImport(shell));
        boolean isSomethingImported = controlList.stream().anyMatch(AbstractImportControl::isImported);
        try {
            try {
                if (isSomethingImported) {
                    this.updateModelAfterImport(shell);
                }
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new RuntimeException(e);
            }
            catch (UserAbortion userAbortion) {
                if (this.modelSession.isDirty()) {
                    this.modelSession.revert();
                }
            }
        }
        finally {
            if (this.modelSession.isDirty()) {
                this.modelSession.revert();
            }
        }
    }

    @Override
    public void updateImportButton() {
        List<ImportModelControl> enableImport = Stream.of(this.importInitial, this.importFinal).filter(i -> i.isEnabled()).toList();
        this.importButton.setEnabled(!enableImport.isEmpty() && enableImport.stream().allMatch(i -> i.isValid()));
    }

    @Override
    protected void resetGroup() {
        this.importFinal.resetControl();
        this.importInitial.resetControl();
        this.initialOption.getButton().setSelection(false);
        this.finalOption.getButton().setSelection(false);
        this.importButton.setEnabled(false);
        this.importFinal.getComboField().setEnabled(false);
        this.importInitial.getComboField().setEnabled(false);
    }
}

