/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.renameservice;

import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.exceptions.UserAbortion;
import org.eclipse.set.basis.extensions.PathExtensions;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.rename.RenameConfirmation;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.files.ToolboxFileService;
import org.eclipse.set.core.services.rename.RenameService;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.swt.widgets.Shell;

public class RenameServiceImpl
implements RenameService {
    @Inject
    private DialogService dialogService;
    @Inject
    ToolboxFileService fileService;

    public ToolboxFile save(Shell shell, ToolboxFile toolboxFile, PlanPro_Schnittstelle planProObject, boolean askUser, Consumer<ToolboxFile> saveAction) throws UserAbortion, IOException {
        Path oldPath = toolboxFile.getPath();
        Path directory = oldPath.getParent();
        String extension = PathExtensions.getExtension((Path)oldPath);
        Path newPath = PlanProSchnittstelleExtensions.getDerivedPath((PlanPro_Schnittstelle)planProObject, (String)directory.toString(), (String)extension, (ExportType)ExportType.PLANNING_RECORDS);
        boolean rename = !oldPath.equals(newPath);
        ToolboxFile newToolboxFile = null;
        boolean deleteOld = false;
        if (rename) {
            if (askUser) {
                String oldFilename = oldPath.getFileName().toString();
                String newFilename = newPath.getFileName().toString();
                RenameConfirmation renameConfirmation = this.dialogService.confirmRename(shell, oldFilename, newFilename);
                switch (renameConfirmation) {
                    case ABORT: {
                        throw new UserAbortion();
                    }
                    case CHANGE: {
                        deleteOld = true;
                        break;
                    }
                    case NEW: {
                        deleteOld = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(renameConfirmation.toString());
                    }
                }
            }
            if (Files.exists(newPath, new LinkOption[0]) && !this.dialogService.confirmOverwrite(shell, newPath)) {
                throw new UserAbortion();
            }
            newToolboxFile = this.fileService.create(toolboxFile);
            newToolboxFile.setPath(newPath);
        } else {
            newToolboxFile = toolboxFile;
        }
        if (deleteOld && rename) {
            toolboxFile.delete(false);
        }
        saveAction.accept(newToolboxFile);
        return newToolboxFile;
    }
}

