/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef.handlers.browser;

import org.eclipse.set.browser.cef.Chromium;
import org.eclipse.set.browser.cef.ChromiumStatic;
import org.eclipse.set.browser.cef.MessageLoop;
import org.eclipse.set.browser.lib.ChromiumLib;
import org.eclipse.set.browser.lib.cef_browser_t;

public class LifeSpanHandler {
    private final Chromium browser;
    private final long cefLifeSpanHandler = ChromiumLib.allocate_cef_life_span_handler_t((Object)this);

    public LifeSpanHandler(Chromium browser) {
        this.browser = browser;
    }

    public void dispose() {
        ChromiumLib.deallocate_cef_life_span_handler_t((long)this.cefLifeSpanHandler);
    }

    public long get() {
        return this.cefLifeSpanHandler;
    }

    private int do_close(long plifeSpanHandler, long id) {
        return 1;
    }

    private void on_after_created(long self, long id) {
        if (id != 0L) {
            ChromiumStatic.browsers.incrementAndGet();
        }
        this.browser.on_after_created(id);
    }

    private void on_before_close(long plifeSpanHandler, long browser) {
        try {
            int id = cef_browser_t.cefswt_get_id((long)browser);
            ChromiumStatic.instances.remove(id).on_before_close(browser);
            int decrementAndGet = ChromiumStatic.browsers.decrementAndGet();
            cef_browser_t.cefswt_free((long)browser);
            --ChromiumStatic.disposingAny;
            if (decrementAndGet == 0 && ChromiumStatic.shuttingDown) {
                ChromiumStatic.shutdown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int on_before_popup(long self, long id, long frame, long target_url, long target_frame_name, int target_disposition, int user_gesture, long popupFeaturesPtr, long windowInfo, long client, long settings, long extraInfo, long no_javascript_access) {
        MessageLoop messageLoop = ChromiumStatic.getMessageLoop();
        messageLoop.pause();
        messageLoop.disablePump();
        int ret = this.browser.on_before_popup(popupFeaturesPtr, windowInfo, client);
        messageLoop.unpause();
        return ret;
    }
}

