/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef.handlers;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.set.browser.lib.ChromiumLib;

public class StringVisitor {
    private final long cefStringVisitor = ChromiumLib.allocate_cef_string_visitor_t((Object)this);
    private final Consumer<String> consumer;
    private final CompletableFuture<Boolean> textReady;

    public StringVisitor(Consumer<String> consumer, CompletableFuture<Boolean> stringReady) {
        this.consumer = consumer;
        this.textReady = stringReady;
    }

    public void dispose() {
        ChromiumLib.deallocate_cef_string_visitor_t((long)this.cefStringVisitor);
    }

    public long get() {
        return this.cefStringVisitor;
    }

    private void visit(long self, long cefString) {
        String newtext;
        String string = newtext = cefString != 0L ? ChromiumLib.cefswt_cefstring_to_java((long)cefString) : null;
        if (newtext != null) {
            this.consumer.accept(newtext);
        }
        this.textReady.complete(newtext != null);
    }
}

