/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.set.browser.cef.Chromium;
import org.eclipse.set.browser.cef.handlers.SchemeHandlerFactory;

public class CEFSchemeHandlerFactory {
    private final Map<String, SchemeHandlerFactory> schemeHandlers = new HashMap<String, SchemeHandlerFactory>();

    void deregisterSchemeHandler(Chromium browser, String hostname) {
        if (this.schemeHandlers.containsKey(hostname) && this.schemeHandlers.get(hostname).removeBrowser(browser)) {
            this.schemeHandlers.remove(hostname);
        }
    }

    void registerSchemeHandler(Chromium browser, String hostname) {
        if (this.schemeHandlers.containsKey(hostname)) {
            this.schemeHandlers.get(hostname).addBrowser(browser);
        } else {
            this.schemeHandlers.put(hostname, new SchemeHandlerFactory(hostname, browser));
        }
    }
}

