/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.services.graph;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.eclipse.set.basis.graph.TopPath;
import org.eclipse.set.basis.graph.TopPoint;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.Ueberhoehungslinie;

public interface BankService {
    public List<BigDecimal> findBankValue(TopPoint var1);

    public List<BankingInformation> findRelevantLineBankings(TopPoint var1);

    public BankingInformation findTOPBanking(Ueberhoehungslinie var1);

    public boolean isFindBankingComplete();

    public record BankingInformation(Ueberhoehungslinie line, TopPath path) {
        public boolean isOnBankingLine(TopPoint point) {
            BigDecimal pointDistance = point.distance();
            if (this.path == null) {
                BigDecimal ueLeft = ((Punkt_Objekt_TOP_Kante_AttributeGroup)this.line.getIDUeberhoehungA().getValue().getPunktObjektTOPKante().get(0)).getAbstand().getWert();
                BigDecimal ueRight = ((Punkt_Objekt_TOP_Kante_AttributeGroup)this.line.getIDUeberhoehungB().getValue().getPunktObjektTOPKante().get(0)).getAbstand().getWert();
                BigDecimal min = ueLeft.min(ueRight);
                BigDecimal max = ueLeft.max(ueRight);
                return min.compareTo(pointDistance) <= 0 && max.compareTo(pointDistance) >= 0;
            }
            Optional pDistance = this.path.getDistance(point);
            if (!pDistance.isPresent()) {
                return false;
            }
            Optional a = this.path.getDistance(new TopPoint((Punkt_Objekt)this.line.getIDUeberhoehungA().getValue()));
            Optional b = this.path.getDistance(new TopPoint((Punkt_Objekt)this.line.getIDUeberhoehungB().getValue()));
            if (!a.isPresent() || !b.isPresent()) {
                return false;
            }
            BigDecimal min = ((BigDecimal)a.get()).min((BigDecimal)b.get());
            BigDecimal max = ((BigDecimal)a.get()).max((BigDecimal)b.get());
            return min.compareTo((BigDecimal)pDistance.get()) <= 0 && max.compareTo((BigDecimal)pDistance.get()) >= 0;
        }
    }
}

