/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.overviewplan.transformator;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.Range;
import org.eclipse.set.feature.overviewplan.track.OverviewplanTrack;
import org.eclipse.set.feature.overviewplan.track.TOPKanteMetaData;
import org.eclipse.set.feature.overviewplan.track.TrackNetworkService;
import org.eclipse.set.feature.siteplan.SiteplanConstants;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.model.siteplan.Position;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.Track;
import org.eclipse.set.model.siteplan.TrackSection;
import org.eclipse.set.model.siteplan.TrackSegment;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class TrackTransformator
extends BaseTransformator<TOP_Kante> {
    @Reference
    private TrackNetworkService trackService;
    private static Map<OverviewplanTrack, Track> mdToTrack = CollectionLiterals.newHashMap();
    private static double edge_length_factor = 10000.0;
    private static double track_lvl_distance_factor = 1000.0;

    public void transform(TOP_Kante topKante) {
        Functions.Function1 _function = it -> it.getSections();
        Functions.Function1 _function_1 = it -> {
            String _wert;
            String _guid = it.getGuid();
            return _guid == (_wert = topKante.getIdentitaet().getWert());
        };
        boolean _exists = IterableExtensions.exists((Iterable)IterableExtensions.flatMap((Iterable)this.state.getTracks(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        if (_exists) {
            return;
        }
        TOPKanteMetaData md = this.trackService.getTOPKanteMetaData(topKante);
        this.transformTrack(md);
        Functions.Function1 _function_2 = it -> it.getSections();
        Consumer<Pair> _function_3 = it -> {
            String color = (String)SiteplanConstants.TOP_KANTEN_COLOR.get(((TrackSection)it.getValue()).getGuid());
            if (color == null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("hsl(");
                Integer _key = (Integer)it.getKey();
                int _plus = _key + 1;
                double _multiply = (double)_plus * 137.5;
                _builder.append((Object)_multiply);
                _builder.append(", 100%, 65%)");
                color = _builder.toString();
                SiteplanConstants.TOP_KANTEN_COLOR.put(((TrackSection)it.getValue()).getGuid(), color);
            }
            TrackSection _value = (TrackSection)it.getValue();
            _value.setColor(color);
        };
        IterableExtensions.indexed((Iterable)IterableExtensions.flatMap((Iterable)this.state.getTracks(), (Functions.Function1)_function_2)).forEach(_function_3);
    }

    private void transformTrack(TOPKanteMetaData md) {
        Functions.Function1 _function = it -> it.getTopEdges().contains(md);
        OverviewplanTrack mdTrack = (OverviewplanTrack)IterableExtensions.findFirst(this.trackService.getTracksCache(), (Functions.Function1)_function);
        if (mdTrack == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Doesn't exist the track contain the TOP_Kante: ");
            String _wert = md.getTopEdge().getIdentitaet().getWert();
            _builder.append(_wert);
            throw new IllegalArgumentException(_builder.toString());
        }
        boolean _containsKey = mdToTrack.containsKey(mdTrack);
        if (_containsKey) {
            return;
        }
        Track track = SiteplanFactory.eINSTANCE.createTrack();
        StringConcatenation _builder_1 = new StringConcatenation();
        int _size = this.state.getTracks().size();
        int _plus = _size + 1;
        _builder_1.append((Object)_plus);
        track.setGuid(_builder_1.toString());
        this.state.getTracks().add((Object)track);
        mdToTrack.put(mdTrack, track);
        Consumer<TOPKanteMetaData> _function_1 = it -> this.createTrackSection((TOPKanteMetaData)it, track, mdTrack);
        mdTrack.getTopEdges().forEach(_function_1);
    }

    private void createTrackSection(TOPKanteMetaData md, Track track, OverviewplanTrack mdTrack) {
        TrackSection section = SiteplanFactory.eINSTANCE.createTrackSection();
        section.setGuid(md.getTopEdge().getIdentitaet().getWert());
        track.getSections().add((Object)section);
        TOP_Knoten _topNodeA = md.getTopNodeA();
        TOP_Knoten _topNodeB = md.getTopNodeB();
        Consumer<TOP_Knoten> _function = it -> {
            boolean _tripleNotEquals;
            TrackSegment segment = SiteplanFactory.eINSTANCE.createTrackSegment();
            segment.setGuid(it.getIdentitaet().getWert());
            Position nodePosition = this.trackService.getTOPNodePosition((TOP_Knoten)it, mdTrack);
            segment.getPositions().add((Object)this.createPosition(nodePosition.getX(), nodePosition.getY()));
            double _y = nodePosition.getY();
            boolean bl = _tripleNotEquals = _y != (double)overviewplanTrack.lvl;
            if (_tripleNotEquals) {
                boolean _not;
                boolean _greaterThan;
                Position nextNodePosition = this.trackService.getTOPNodePosition(md.getNextTopNode((TOP_Knoten)it), mdTrack);
                Functions.Function1 _function_1 = intersect -> this.trackService.getTrack((TOPKanteMetaData)intersect);
                Set connectTrack = IterableExtensions.toSet((Iterable)ListExtensions.map(md.getIntersectEdgeAt((TOP_Knoten)it), (Functions.Function1)_function_1));
                int _size = connectTrack.size();
                boolean bl2 = _greaterThan = _size > 1;
                if (_greaterThan) {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("By TOP_Knoten: ");
                    String _wert = it.getIdentitaet().getWert();
                    _builder.append(_wert);
                    _builder.append(" exist more than two track");
                    throw new IllegalArgumentException(_builder.toString());
                }
                Range edgeRange = Range.of((Comparable)Double.valueOf(nodePosition.getX()), (Comparable)Double.valueOf(nextNodePosition.getX()));
                double _y_1 = nodePosition.getY();
                double _minus = _y_1 - (double)overviewplanTrack.lvl;
                double _abs = Math.abs(_minus);
                double offSetX = _abs / 10.0;
                double _x = nodePosition.getX();
                double transformX = _x + offSetX;
                boolean _contains = edgeRange.contains((Object)transformX);
                boolean bl3 = _not = !_contains;
                if (_not) {
                    double _minus_1;
                    double _x_1 = nodePosition.getX();
                    transformX = _minus_1 = _x_1 - offSetX;
                }
                segment.getPositions().add((Object)this.createPosition(transformX, overviewplanTrack.lvl));
            }
            section.getSegments().add((Object)segment);
        };
        Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TOP_Knoten[]{_topNodeA, _topNodeB})).forEach(_function);
    }

    private Position createPosition(double x, double y) {
        Position position = SiteplanFactory.eINSTANCE.createPosition();
        position.setX(x * edge_length_factor);
        position.setY(y * track_lvl_distance_factor);
        return position;
    }
}

