/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.math;

import com.google.common.math.BigIntegerMath;
import java.util.ArrayList;
import java.util.List;

public class Bloss {
    private final double[][] amnCache;
    private final double curvature;
    private final int maxIterations;
    private final double totalLength;

    public Bloss(double radius, double totalLength, int iterations) {
        this.totalLength = totalLength;
        this.maxIterations = iterations;
        this.curvature = radius != 0.0 ? 1.0 / radius : 0.0;
        int nMax = 4 * iterations;
        this.amnCache = new double[iterations][nMax];
        int i = 0;
        while (i < iterations) {
            this.amnCache[i] = new double[nMax];
            int j = 0;
            while (j < nMax) {
                this.amnCache[i][j] = Double.NaN;
                ++j;
            }
            ++i;
        }
    }

    public List<double[]> calculate(int segmentCount) {
        double segmentLength = this.totalLength / (double)(segmentCount - 1);
        ArrayList<double[]> positions = new ArrayList<double[]>();
        int i = 0;
        while (i < segmentCount) {
            positions.add(this.calculatePoint(segmentLength * (double)i));
            ++i;
        }
        return positions;
    }

    public double[] calculatePoint(double length) {
        return new double[]{this.x(length), this.y(length)};
    }

    private double amn(int m, int n) {
        if (this.amnCache[m - 1][n - 1] != this.amnCache[m - 1][n - 1]) {
            this.amnCache[m - 1][n - 1] = this.amnUncached(m, n);
        }
        return this.amnCache[m - 1][n - 1];
    }

    private double amnUncached(int m, int n) {
        if (m == 1) {
            return this.an(n);
        }
        double result = 0.0;
        if (n == m || n == m + 1 || n == m + 2) {
            int j = 1;
            while (j <= n - m + 1) {
                result += this.amn(m - 1, n - j) * this.an(j);
                ++j;
            }
        } else if (n >= m + 3 && n <= 4 * m - 3) {
            int j = 1;
            while (j <= 4) {
                result += this.amn(m - 1, n - j) * this.an(j);
                ++j;
            }
        } else if (n == 4 * m || n == 4 * m - 1 || n == 4 * m - 2) {
            int j = n - 4 * m + 4;
            while (j <= 4) {
                result += this.amn(m - 1, n - j) * this.an(j);
                ++j;
            }
        } else {
            throw new RuntimeException("Invalid value for n in amn");
        }
        return result;
    }

    private double an(int n) {
        if (n == 1) {
            return this.curvature;
        }
        if (n == 2) {
            return 0.0;
        }
        if (n == 3) {
            return -this.curvature / Math.pow(this.totalLength, 2.0);
        }
        if (n == 4) {
            return this.curvature / (2.0 * Math.pow(this.totalLength, 3.0));
        }
        throw new RuntimeException("Invalid value for n in an");
    }

    private double x(double l) {
        double result = l;
        int m = 2;
        while (m <= this.maxIterations) {
            double sign = Math.pow(-1.0, (float)m / 2.0f);
            double fact = BigIntegerMath.factorial((int)m).doubleValue();
            double innerSum = 0.0;
            int n = m;
            while (n <= 4 * m) {
                innerSum += this.amn(m, n) * Math.pow(l, (float)n + 1.0f) / (double)(n + 1);
                ++n;
            }
            result += sign / fact * innerSum;
            m += 2;
        }
        return result;
    }

    private double y(double l) {
        double result = 0.0;
        int m = 1;
        while (m <= this.maxIterations) {
            double sign = Math.pow(-1.0, (float)(m - 1) / 2.0f);
            double fact = BigIntegerMath.factorial((int)m).doubleValue();
            double innerSum = 0.0;
            int n = m;
            while (n <= 4 * m) {
                innerSum += this.amn(m, n) * Math.pow(l, (float)n + 1.0f) / (double)(n + 1);
                ++n;
            }
            result += sign / fact * innerSum;
            m += 2;
        }
        return result;
    }
}

