/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.nls.editor;

import java.util.Optional;
import org.eclipse.scout.sdk.core.s.nls.ITranslationEntry;
import org.eclipse.scout.sdk.core.s.nls.ITranslationStore;
import org.eclipse.scout.sdk.core.s.nls.Language;
import org.eclipse.scout.sdk.core.util.Ensure;

public class NlsTableCell {
    private final int m_column;
    private final ITranslationEntry m_entry;
    private final Language m_language;

    public NlsTableCell(int column, ITranslationEntry entry, Language language) {
        this.m_column = column;
        this.m_entry = (ITranslationEntry)Ensure.notNull((Object)entry);
        this.m_language = language;
    }

    public int column() {
        return this.m_column;
    }

    public ITranslationEntry entry() {
        return this.m_entry;
    }

    public Optional<Language> language() {
        return Optional.ofNullable(this.m_language);
    }

    public String text() {
        if (this.column() == 1) {
            return this.entry().key();
        }
        if (this.m_language != null) {
            return this.entry().text(this.m_language).orElse(null);
        }
        return null;
    }

    public ITranslationStore store() {
        return this.entry().store();
    }

    public int hashCode() {
        return 31 * this.m_column + this.m_entry.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NlsTableCell other = (NlsTableCell)obj;
        return this.m_column == other.m_column && this.m_entry.equals(other.m_entry);
    }
}

