/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.ClassMatcher;
import org.eclipse.jetty.util.component.Environment;

public class WebAppClassLoading {
    public static final String PROTECTED_CLASSES_ATTRIBUTE = "org.eclipse.jetty.webapp.systemClasses";
    public static final String HIDDEN_CLASSES_ATTRIBUTE = "org.eclipse.jetty.webapp.serverClasses";
    public static final ClassMatcher DEFAULT_PROTECTED_CLASSES = new ClassMatcher(new String[]{"java.", "javax.", "jakarta.", "org.xml.", "org.w3c."});
    public static final ClassMatcher DEFAULT_HIDDEN_CLASSES = new ClassMatcher("org.eclipse.jetty.");

    public static ClassMatcher getProtectedClasses(Server server) {
        return WebAppClassLoading.getClassMatcher((Attributes)server, PROTECTED_CLASSES_ATTRIBUTE, null);
    }

    public static ClassMatcher getProtectedClasses(Environment environment) {
        return WebAppClassLoading.getClassMatcher((Attributes)environment, PROTECTED_CLASSES_ATTRIBUTE, DEFAULT_PROTECTED_CLASSES);
    }

    public static void addProtectedClasses(String ... patterns) {
        DEFAULT_PROTECTED_CLASSES.add(patterns);
    }

    public static void addProtectedClasses(Attributes attributes, String ... patterns) {
        if (patterns != null && patterns.length > 0) {
            WebAppClassLoading.getClassMatcher(attributes, PROTECTED_CLASSES_ATTRIBUTE, null).add(patterns);
        }
    }

    public static void addProtectedClasses(Server server, String ... patterns) {
        if (patterns != null && patterns.length > 0) {
            WebAppClassLoading.getClassMatcher((Attributes)server, PROTECTED_CLASSES_ATTRIBUTE, null).add(patterns);
        }
    }

    public static void addProtectedClasses(Environment environment, String ... patterns) {
        if (patterns != null && patterns.length > 0) {
            WebAppClassLoading.getClassMatcher((Attributes)environment, PROTECTED_CLASSES_ATTRIBUTE, DEFAULT_PROTECTED_CLASSES).add(patterns);
        }
    }

    public static ClassMatcher getHiddenClasses(Server server) {
        return WebAppClassLoading.getClassMatcher((Attributes)server, HIDDEN_CLASSES_ATTRIBUTE, null);
    }

    public static ClassMatcher getHiddenClasses(Environment environment) {
        return WebAppClassLoading.getClassMatcher((Attributes)environment, HIDDEN_CLASSES_ATTRIBUTE, DEFAULT_HIDDEN_CLASSES);
    }

    public static void addHiddenClasses(String ... patterns) {
        DEFAULT_HIDDEN_CLASSES.add(patterns);
    }

    public static void addHiddenClasses(Attributes attributes, String ... patterns) {
        if (patterns != null && patterns.length > 0) {
            WebAppClassLoading.getClassMatcher(attributes, HIDDEN_CLASSES_ATTRIBUTE, null).add(patterns);
        }
    }

    public static void addHiddenClasses(Server server, String ... patterns) {
        if (patterns != null && patterns.length > 0) {
            WebAppClassLoading.getClassMatcher((Attributes)server, HIDDEN_CLASSES_ATTRIBUTE, null).add(patterns);
        }
    }

    public static void addHiddenClasses(Environment environment, String ... patterns) {
        if (patterns != null && patterns.length > 0) {
            WebAppClassLoading.getClassMatcher((Attributes)environment, HIDDEN_CLASSES_ATTRIBUTE, DEFAULT_HIDDEN_CLASSES).add(patterns);
        }
    }

    private static ClassMatcher getClassMatcher(Attributes attributes, String attribute, ClassMatcher defaultPatterns) {
        ClassMatcher classMatcher;
        Object existing = attributes.getAttribute(attribute);
        if (existing instanceof ClassMatcher) {
            ClassMatcher cm = (ClassMatcher)existing;
            return cm;
        }
        if (existing instanceof String[]) {
            String[] stringArray = (String[])existing;
            classMatcher = new ClassMatcher(stringArray);
        } else {
            classMatcher = new ClassMatcher(defaultPatterns);
        }
        ClassMatcher classMatcher2 = classMatcher;
        attributes.setAttribute(attribute, (Object)classMatcher2);
        return classMatcher2;
    }
}

