/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.widgets.FileUploadRunnable;
import org.eclipse.swt.internal.widgets.ImageUtil;
import org.eclipse.swt.internal.widgets.LayoutUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UploadPanel
extends Composite {
    private final String[] fileNames;
    private Image emptyIcon;
    private Image waitingIcon;
    private Image uploadingIcon;
    private Image finishedIcon;
    private Image failedIcon;
    private final List<Label> icons;

    public UploadPanel(Composite parent, String[] fileNames) {
        super(parent, 0);
        this.fileNames = fileNames;
        this.initImages();
        this.setLayout((Layout)LayoutUtil.createGridLayout(1, 0, 5));
        this.icons = new ArrayList<Label>();
        this.createChildren();
    }

    private void initImages() {
        Display display = this.getDisplay();
        this.emptyIcon = ImageUtil.getImage(display, "empty.png");
        this.waitingIcon = ImageUtil.getImage(display, "waiting.png");
        this.uploadingIcon = ImageUtil.getImage(display, "uploading.png");
        this.finishedIcon = ImageUtil.getImage(display, "finished.png");
        this.failedIcon = ImageUtil.getImage(display, "failed.png");
    }

    private void createChildren() {
        String[] stringArray = this.fileNames;
        int n = this.fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            if (fileName != null) {
                Composite container = new Composite((Composite)this, 2048);
                container.setLayout((Layout)UploadPanel.createContainerLayout());
                container.setLayoutData((Object)LayoutUtil.createHorizontalFillData());
                Label icon = new Label(container, 0);
                icon.setImage(this.emptyIcon);
                this.icons.add(icon);
                Label name = new Label(container, 0);
                name.setLayoutData((Object)LayoutUtil.createHorizontalFillData());
                name.setText(fileName);
            }
            ++n2;
        }
    }

    private static GridLayout createContainerLayout() {
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        return layout;
    }

    void updateIcons(FileUploadRunnable.State state) {
        for (Label icon : this.icons) {
            if (icon.isDisposed()) continue;
            icon.setImage(this.getImage(state));
        }
    }

    private Image getImage(FileUploadRunnable.State state) {
        Image image = this.emptyIcon;
        if (state.equals((Object)FileUploadRunnable.State.WAITING)) {
            image = this.waitingIcon;
        } else if (state.equals((Object)FileUploadRunnable.State.UPLOADING)) {
            image = this.uploadingIcon;
        } else if (state.equals((Object)FileUploadRunnable.State.FINISHED)) {
            image = this.finishedIcon;
        } else if (state.equals((Object)FileUploadRunnable.State.FAILED)) {
            image = this.failedIcon;
        }
        return image;
    }
}

