/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.remote;

import java.io.Serializable;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;

public abstract class RemoteObjectImpl
implements RemoteObject,
Serializable {
    private final String id;
    private boolean destroyed;
    private OperationHandler handler;

    public RemoteObjectImpl(String id, String createType) {
        this.id = id;
        this.destroyed = false;
    }

    public String getId() {
        return this.id;
    }

    public void set(String name, int value) {
        ParamCheck.notNullOrEmpty(name, "name");
        this.checkState();
    }

    public void set(String name, double value) {
        ParamCheck.notNullOrEmpty(name, "name");
        this.checkState();
    }

    public void set(String name, boolean value) {
        ParamCheck.notNullOrEmpty(name, "name");
        this.checkState();
    }

    public void set(String name, String value) {
        ParamCheck.notNullOrEmpty(name, "name");
        this.checkState();
    }

    public void set(String name, JsonValue value) {
        ParamCheck.notNullOrEmpty(name, "name");
        ParamCheck.notNull(value, "value");
        this.checkState();
    }

    public void listen(String eventType, boolean listen) {
        ParamCheck.notNullOrEmpty(eventType, "eventType");
        this.checkState();
    }

    public void call(String method, JsonObject parameters) {
        ParamCheck.notNullOrEmpty(method, "method");
        this.checkState();
    }

    public void destroy() {
        this.checkState();
        this.destroyed = true;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void markDestroyed() {
        this.destroyed = true;
    }

    public void setHandler(OperationHandler handler) {
        this.handler = handler;
    }

    public OperationHandler getHandler() {
        return this.handler;
    }

    void checkState() {
        if (!ContextProvider.hasContext()) {
            throw new IllegalStateException("Remote object called from wrong thread");
        }
        if (this.destroyed) {
            throw new IllegalStateException("Remote object is destroyed");
        }
    }

    public static interface RenderRunnable {
        public void render(ProtocolMessageWriter var1);
    }
}

