/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ccombokit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.custom.ccombokit.CComboOperationHandler;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Widget;

public final class CComboLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Combo";
    private static final String[] ALLOWED_STYLES = new String[]{"FLAT", "BORDER"};
    static final String PROP_ITEMS = "items";
    static final String PROP_TEXT = "text";
    static final String PROP_SELECTION_INDEX = "selectionIndex";
    static final String PROP_SELECTION = "selection";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_LIST_VISIBLE = "listVisible";
    static final String PROP_EDITABLE = "editable";
    static final String PROP_VISIBLE_ITEM_COUNT = "visibleItemCount";
    static final String PROP_SELECTION_LISTENER = "Selection";
    static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    static final String PROP_MODIFY_LISTENER = "Modify";
    private static final String[] DEFAUT_ITEMS = new String[0];
    private static final Integer DEFAULT_SELECTION_INDEX = new Integer(-1);
    private static final Point DEFAULT_SELECTION = new Point(0, 0);
    private static final int DEFAULT_VISIBLE_ITEM_COUNT = 5;

    public void preserveValues(Widget widget) {
        CCombo ccombo = (CCombo)widget;
        ControlLCAUtil.preserveValues(ccombo);
        WidgetLCAUtil.preserveCustomVariant(ccombo);
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_ITEMS, ccombo.getItems());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_SELECTION_INDEX, ccombo.getSelectionIndex());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_SELECTION, ccombo.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_TEXT_LIMIT, CComboLCA.getTextLimit(ccombo));
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_VISIBLE_ITEM_COUNT, ccombo.getVisibleItemCount());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_TEXT, ccombo.getText());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_LIST_VISIBLE, ccombo.getListVisible());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_EDITABLE, (Object)ccombo.getEditable());
        WidgetLCAUtil.preserveListener(ccombo, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(ccombo, 13));
        WidgetLCAUtil.preserveListener(ccombo, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(ccombo, 14));
        WidgetLCAUtil.preserveListener(ccombo, PROP_MODIFY_LISTENER, CComboLCA.hasModifyListener(ccombo));
    }

    public void renderInitialization(Widget widget) throws IOException {
        CCombo ccombo = (CCombo)widget;
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(ccombo, TYPE);
        remoteObject.setHandler(new CComboOperationHandler(ccombo));
        remoteObject.set("parent", WidgetUtil.getId(ccombo.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(ccombo, ALLOWED_STYLES)));
        remoteObject.set("ccombo", true);
    }

    public void renderChanges(Widget widget) throws IOException {
        CCombo ccombo = (CCombo)widget;
        ControlLCAUtil.renderChanges(ccombo);
        WidgetLCAUtil.renderCustomVariant(ccombo);
        CComboLCA.renderVisibleItemCount(ccombo);
        CComboLCA.renderItems(ccombo);
        CComboLCA.renderListVisible(ccombo);
        CComboLCA.renderSelectionIndex(ccombo);
        CComboLCA.renderEditable(ccombo);
        CComboLCA.renderText(ccombo);
        CComboLCA.renderSelection(ccombo);
        CComboLCA.renderTextLimit(ccombo);
        CComboLCA.renderListenSelection(ccombo);
        CComboLCA.renderListenDefaultSelection(ccombo);
        CComboLCA.renderListenModify(ccombo);
    }

    private static void renderVisibleItemCount(CCombo ccombo) {
        int defValue = 5;
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_VISIBLE_ITEM_COUNT, ccombo.getVisibleItemCount(), defValue);
    }

    private static void renderItems(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_ITEMS, ccombo.getItems(), DEFAUT_ITEMS);
    }

    private static void renderListVisible(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_LIST_VISIBLE, ccombo.getListVisible(), false);
    }

    private static void renderSelectionIndex(CCombo ccombo) {
        boolean textChanged;
        Integer newValue = ccombo.getSelectionIndex();
        boolean selectionChanged = WidgetLCAUtil.hasChanged(ccombo, PROP_SELECTION_INDEX, newValue, DEFAULT_SELECTION_INDEX);
        boolean bl = textChanged = !ccombo.getEditable() && WidgetLCAUtil.hasChanged(ccombo, PROP_TEXT, ccombo.getText(), "");
        if (selectionChanged || textChanged) {
            RemoteObjectFactory.getRemoteObject(ccombo).set(PROP_SELECTION_INDEX, newValue);
        }
    }

    private static void renderEditable(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_EDITABLE, ccombo.getEditable(), true);
    }

    private static void renderText(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_TEXT, ccombo.getText(), "");
    }

    private static void renderSelection(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_SELECTION, ccombo.getSelection(), DEFAULT_SELECTION);
    }

    private static void renderTextLimit(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_TEXT_LIMIT, CComboLCA.getTextLimit(ccombo), null);
    }

    private static void renderListenSelection(CCombo ccombo) {
        WidgetLCAUtil.renderListener(ccombo, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(ccombo, 13), false);
    }

    private static void renderListenDefaultSelection(CCombo ccombo) {
        WidgetLCAUtil.renderListener(ccombo, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(ccombo, 14), false);
    }

    private static void renderListenModify(CCombo ccombo) {
        WidgetLCAUtil.renderListener(ccombo, PROP_MODIFY_LISTENER, CComboLCA.hasModifyListener(ccombo), false);
    }

    private static boolean hasModifyListener(CCombo ccombo) {
        return EventLCAUtil.isListening(ccombo, 24) || EventLCAUtil.isListening(ccombo, 25);
    }

    private static Integer getTextLimit(CCombo ccombo) {
        Integer result = ccombo.getTextLimit();
        if (result == Integer.MAX_VALUE) {
            result = null;
        }
        return result;
    }
}

