/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.addons.internal.canvas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DrawingsCache
implements Serializable {
    private final List<String> cachedDrawings;
    private final List<String> removedDrawings;
    private final Object lock = new Object();

    public DrawingsCache() {
        this.cachedDrawings = new ArrayList<String>();
        this.removedDrawings = new ArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.cachedDrawings.clear();
            this.removedDrawings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCachedDrawings() {
        Object object = this.lock;
        synchronized (object) {
            this.cachedDrawings.clear();
        }
    }

    public boolean hasUndo() {
        return !this.cachedDrawings.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        Object object = this.lock;
        synchronized (object) {
            int lastObjectIndex = this.cachedDrawings.size() - 1;
            String lastObject = this.cachedDrawings.remove(lastObjectIndex);
            this.removedDrawings.add(lastObject);
        }
    }

    public boolean hasRedo() {
        return !this.removedDrawings.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        Object object = this.lock;
        synchronized (object) {
            int lastObjectIndex = this.removedDrawings.size() - 1;
            String lastObject = this.removedDrawings.remove(lastObjectIndex);
            this.cachedDrawings.add(lastObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRemoved() {
        Object object = this.lock;
        synchronized (object) {
            this.removedDrawings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(String drawings) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.cachedDrawings.contains(drawings)) {
                this.cachedDrawings.add(drawings);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheAll(List<String> drawings) {
        Object object = this.lock;
        synchronized (object) {
            this.cachedDrawings.addAll(drawings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRemovedDrawings() {
        Object object = this.lock;
        synchronized (object) {
            this.removedDrawings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllRemoved(List<String> removedDrawings) {
        Object object = this.lock;
        synchronized (object) {
            this.removedDrawings.addAll(removedDrawings);
        }
    }

    public List<String> getCachedDrawings() {
        return new ArrayList<String>(this.cachedDrawings);
    }

    public List<String> getRemovedDrawings() {
        return new ArrayList<String>(this.removedDrawings);
    }
}

