/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;

public class Cursor
extends Resource {
    private final int value;

    private Cursor(int style) {
        super(null);
        Cursor.checkStyle(style);
        this.value = style;
    }

    public Cursor(Device device, int style) {
        super(Cursor.checkDevice(device));
        Cursor.checkStyle(style);
        this.value = style;
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == this) {
            result = true;
        } else if (object instanceof Cursor) {
            Cursor cursor = (Cursor)object;
            result = cursor.value == this.value;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        return 101 * this.value;
    }

    public String toString() {
        Object result = this.isDisposed() ? "Cursor {*DISPOSED*}" : "Cursor {" + this.value + "}";
        return result;
    }

    private static void checkStyle(int style) {
        switch (style) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
    }
}

