/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo.change;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.util.ObjectUtil;

@Persistent
public class Update
extends TopologyChange {
    private static final long serialVersionUID = 1L;
    Topology.Component<?> component;

    public Update(int sequenceNumber, Topology.Component<?> component) {
        super(sequenceNumber);
        ObjectUtil.checkNull("component", component);
        ObjectUtil.checkNull("component.resourceId", component.getResourceId());
        this.component = component;
    }

    Update(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.component = Topology.Component.readFastExternal(null, in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        this.component.writeFastExternal(out, serialVersion);
    }

    private Update() {
    }

    @Override
    public TopologyChange.Type getType() {
        return TopologyChange.Type.UPDATE;
    }

    @Override
    public Topology.Component<?> getComponent() {
        return this.component;
    }

    @Override
    public ResourceId getResourceId() {
        return this.component.getResourceId();
    }

    @Override
    public Update clone() {
        Object comp = this.component.clone();
        assert (((ResourceId)((Topology.Component)comp).getResourceId()).getType() != ResourceId.ResourceType.REP_GROUP);
        ((Topology.Component)comp).setTopology(null);
        return new Update(this.sequenceNumber, (Topology.Component<?>)comp);
    }

    @Override
    public String toString() {
        return "Update " + this.component.getResourceId() + " seq=" + this.sequenceNumber;
    }
}

