/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.wst.jsdt.debug.core.jsdi.connect.Connector;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;

public class ConnectorsManager
implements IRegistryEventListener {
    private static final String ID = "id";
    private HashMap connectors;

    public ConnectorsManager() {
        RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, "launchingConnectors");
    }

    public synchronized List getConnectors() {
        this.initializeConnectors();
        ArrayList list = new ArrayList(this.connectors.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof Connector && arg1 instanceof Connector) {
                    return ((Connector)arg0).name().compareTo(((Connector)arg1).name());
                }
                return -1;
            }
        });
        return Collections.unmodifiableList(list);
    }

    public synchronized Connector getConnector(String connectorid) {
        this.initializeConnectors();
        return (Connector)this.connectors.get(connectorid);
    }

    private synchronized void initializeConnectors() {
        if (this.connectors == null) {
            this.connectors = new HashMap();
            IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint("org.eclipse.wst.jsdt.debug.core", "launchingConnectors");
            if (point != null) {
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    try {
                        IConfigurationElement[] elements = extension.getConfigurationElements();
                        int j = 0;
                        while (j < elements.length) {
                            IConfigurationElement element = elements[j];
                            if ("connector".equalsIgnoreCase(element.getName())) {
                                this.connectors.put(element.getAttribute(ID), element.createExecutableExtension("class"));
                            }
                            ++j;
                        }
                    }
                    catch (InvalidRegistryObjectException e) {
                        JavaScriptDebugPlugin.log(e);
                    }
                    catch (CoreException e) {
                        JavaScriptDebugPlugin.log(e);
                    }
                    ++i;
                }
            }
        }
    }

    public void added(IExtension[] extensions) {
        this.connectors = null;
    }

    public void added(IExtensionPoint[] extensionPoints) {
        this.connectors = null;
    }

    public void removed(IExtension[] extensions) {
        this.connectors = null;
    }

    public void removed(IExtensionPoint[] extensionPoints) {
        this.connectors = null;
    }

    public void dispose() {
        if (this.connectors != null) {
            this.connectors.clear();
            this.connectors = null;
        }
    }
}

