/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.dialogs.factory;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.factory.FactoryAddCommand;
import org.eclipse.wb.internal.core.editor.palette.dialogs.factory.FactoryAbstractDialog;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.dialogfields.ComboDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;

public final class FactoryAddDialog
extends FactoryAbstractDialog {
    private final PaletteInfo m_palette;
    private final CategoryInfo m_initialCategory;
    private ComboDialogField m_categoryField;

    public FactoryAddDialog(Shell parentShell, AstEditor editor, boolean forStatic, PaletteInfo palette, CategoryInfo initialCategory) {
        super(parentShell, editor, forStatic, forStatic ? Messages.FactoryAddDialog_titleStatic : Messages.FactoryAddDialog_titleInstance, forStatic ? Messages.FactoryAddDialog_messageStatic : Messages.FactoryAddDialog_messageInstance);
        this.m_palette = palette;
        this.m_initialCategory = initialCategory;
    }

    @Override
    protected void createControls(Composite container) {
        super.createControls(container);
        this.m_categoryField = FactoryAddDialog.createCategoryField(this.m_palette, this.m_initialCategory);
        this.doCreateField((DialogField)this.m_categoryField, Messages.FactoryAddDialog_categoryLabel);
        this.m_visibleField.setSelection(true);
    }

    @Override
    protected Command createCommand() {
        String id = "custom_" + System.currentTimeMillis();
        String name = this.m_nameField.getText().trim();
        String description = this.getDescriptionText();
        String factoryClassName = this.m_factoryClassField.getText();
        String methodSignature = this.m_methodSignatureField.getText();
        CategoryInfo category = this.m_palette.getCategories().get(this.m_categoryField.getSelectionIndex());
        return new FactoryAddCommand(id, name, description, this.m_visibleField.getSelection(), factoryClassName, methodSignature, this.m_forStatic, category);
    }
}

