/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.AttributeGroup;
import org.eclipse.php.core.ast.nodes.AttributedExpression;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.core.compiler.PHPFlags;

public class AnonymousClassDeclaration
extends AttributedExpression {
    private Expression superClass;
    protected ASTNode.NodeList<Identifier> interfaces = new ASTNode.NodeList(INTERFACES_PROPERTY);
    private Block body;
    private int modifier;
    public static final ChildPropertyDescriptor SUPER_CLASS_PROPERTY = new ChildPropertyDescriptor(AnonymousClassDeclaration.class, "superClass", Expression.class, false, false);
    public static final ChildListPropertyDescriptor INTERFACES_PROPERTY = new ChildListPropertyDescriptor(AnonymousClassDeclaration.class, "interfaces", Identifier.class, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(AnonymousClassDeclaration.class, "body", Block.class, true, true);
    public static final ChildListPropertyDescriptor ATTRIBUTES_PROPERTY = new ChildListPropertyDescriptor(AnonymousClassDeclaration.class, "attributes", AttributeGroup.class, true);
    public static final SimplePropertyDescriptor MODIFIER_PROPERTY = new SimplePropertyDescriptor(AnonymousClassDeclaration.class, "modifier", Integer.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS_PHP8;
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS_PHP83;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(3);
        propertyList.add(SUPER_CLASS_PROPERTY);
        propertyList.add(INTERFACES_PROPERTY);
        propertyList.add(BODY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
        propertyList = new ArrayList(4);
        propertyList.add(SUPER_CLASS_PROPERTY);
        propertyList.add(INTERFACES_PROPERTY);
        propertyList.add(BODY_PROPERTY);
        propertyList.add(ATTRIBUTES_PROPERTY);
        PROPERTY_DESCRIPTORS_PHP8 = Collections.unmodifiableList(propertyList);
        propertyList = new ArrayList(5);
        propertyList.add(SUPER_CLASS_PROPERTY);
        propertyList.add(INTERFACES_PROPERTY);
        propertyList.add(BODY_PROPERTY);
        propertyList.add(ATTRIBUTES_PROPERTY);
        propertyList.add(MODIFIER_PROPERTY);
        PROPERTY_DESCRIPTORS_PHP83 = Collections.unmodifiableList(propertyList);
    }

    public AnonymousClassDeclaration(AST ast) {
        super(ast);
    }

    public AnonymousClassDeclaration(int start, int end, AST ast, Expression superClass, List<Identifier> interfaces, Block body, List<AttributeGroup> attributes) {
        this(start, end, ast, 0, superClass, interfaces, body, attributes);
    }

    public AnonymousClassDeclaration(int start, int end, AST ast, int modifier, Expression superClass, List<Identifier> interfaces, Block body, List<AttributeGroup> attributes) {
        super(start, end, ast);
        this.setModifier(modifier);
        this.setSuperClass(superClass);
        if (interfaces != null) {
            Iterator<Identifier> iterator = interfaces.iterator();
            while (iterator.hasNext()) {
                this.interfaces.add(iterator.next());
            }
        }
        this.setBody(body);
        if (attributes != null) {
            this.attributes().addAll(attributes);
        }
    }

    public AnonymousClassDeclaration(int start, int end, AST ast, Expression superClass, List<Identifier> interfaces, Block body) {
        this(start, end, ast, superClass, interfaces, body, null);
    }

    public Block getBody() {
        return this.body;
    }

    public Expression getSuperClass() {
        return this.superClass;
    }

    public List<Identifier> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (AttributeGroup attr : this.attributes()) {
            attr.accept(visitor);
        }
        if (this.superClass != null) {
            this.superClass.accept(visitor);
        }
        if (this.interfaces != null) {
            for (Identifier identifier : this.interfaces) {
                identifier.accept(visitor);
            }
        }
        this.body.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        for (AttributeGroup attr : this.attributes()) {
            attr.traverseTopDown(visitor);
        }
        if (this.superClass != null) {
            this.superClass.traverseTopDown(visitor);
        }
        if (this.interfaces != null) {
            for (Identifier identifier : this.interfaces) {
                identifier.traverseTopDown(visitor);
            }
        }
        this.body.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        if (this.superClass != null) {
            this.superClass.traverseBottomUp(visitor);
        }
        if (this.interfaces != null) {
            for (Identifier identifier : this.interfaces) {
                identifier.traverseBottomUp(visitor);
            }
        }
        for (AttributeGroup attr : this.attributes()) {
            attr.traverseBottomUp(visitor);
        }
        this.body.traverseBottomUp(visitor);
    }

    @Override
    void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void toString(StringBuilder buffer, String tab) {
        buffer.append(tab).append("<AnonymousClassDeclaration");
        this.appendInterval(buffer);
        if (this.modifier != 0) {
            buffer.append("modifier=\"").append(this.getModifierString()).append("\"");
        }
        buffer.append(">\n");
        this.toStringAttributes(buffer, tab + "\t");
        buffer.append("\t").append(tab).append("<SuperClass>\n");
        if (this.superClass != null) {
            this.superClass.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("<SuperClass>\n");
        buffer.append("\t").append(tab).append("<Interfaces>\n");
        if (this.interfaces != null) {
            for (Identifier identifier : this.interfaces) {
                identifier.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
        }
        buffer.append("\t").append(tab).append("<Interfaces>\n");
        buffer.append("\t").append(tab).append("<Body>\n");
        if (this.body != null) {
            this.body.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("<Body>\n");
        buffer.append(tab).append("</AnonymousClassDeclaration>");
    }

    public void setBody(Block body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        Block oldChild = this.body;
        this.preReplaceChild(oldChild, body, BODY_PROPERTY);
        this.body = body;
        this.postReplaceChild(oldChild, body, BODY_PROPERTY);
    }

    public void setSuperClass(Expression superClass) {
        Expression oldChild = this.superClass;
        this.preReplaceChild(oldChild, superClass, SUPER_CLASS_PROPERTY);
        this.superClass = superClass;
        this.postReplaceChild(oldChild, superClass, SUPER_CLASS_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression superClass = ASTNode.copySubtree(target, this.getSuperClass());
        List<Identifier> interfaces = ASTNode.copySubtrees(target, this.getInterfaces());
        Block body = ASTNode.copySubtree(target, this.getBody());
        List<AttributeGroup> attributes = ASTNode.copySubtrees(target, this.attributes());
        int modifier = this.modifier;
        return new AnonymousClassDeclaration(this.getStart(), this.getEnd(), target, modifier, superClass, interfaces, body, attributes);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == BODY_PROPERTY) {
            if (get) {
                return this.getBody();
            }
            this.setBody((Block)child);
            return null;
        }
        if (property == SUPER_CLASS_PROPERTY) {
            if (get) {
                return this.getSuperClass();
            }
            this.setSuperClass((Identifier)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final List<? extends ASTNode> internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == INTERFACES_PROPERTY) {
            return this.getInterfaces();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    public int getType() {
        return 77;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        if (PHPVersion.PHP8_0.isGreaterThan(apiLevel)) {
            return PROPERTY_DESCRIPTORS;
        }
        if (PHPVersion.PHP8_3.isGreaterThan(apiLevel)) {
            return PROPERTY_DESCRIPTORS_PHP8;
        }
        return PROPERTY_DESCRIPTORS_PHP83;
    }

    @Override
    protected ChildListPropertyDescriptor getAttributesProperty() {
        return ATTRIBUTES_PROPERTY;
    }

    public final void setModifier(int value) {
        this.preValueChange(MODIFIER_PROPERTY);
        this.modifier = value;
        this.postValueChange(MODIFIER_PROPERTY);
    }

    public int getModifier() {
        return this.modifier;
    }

    @Override
    final int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int child) {
        if (property == MODIFIER_PROPERTY) {
            if (get) {
                return this.getModifier();
            }
            this.setModifier(child);
            return 0;
        }
        return super.internalGetSetIntProperty(property, get, child);
    }

    public String getModifierString() {
        return PHPFlags.toString(this.modifier);
    }
}

